/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.util;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Optional;
import org.mule.munit.common.util.FreePortFinder;
import org.mule.munit.common.util.IllegalPortDefinitionException;

public class RunnerPortProvider {
    public static final int MIN_PORT_NUMBER = 60000;
    public static final int MAX_PORT_NUMBER = 60500;
    public static final String MUNIT_SERVER_PORT = "munit.server.port";

    public Integer getPort() throws IllegalPortDefinitionException {
        Optional<Integer> predefinedPort = this.getPredefinedPort();
        Integer port = predefinedPort.orElseGet(this::getAndSetFreePort);
        if (port <= 0) {
            throw new IllegalPortDefinitionException("The defined port [" + port + "] is outside the valid range");
        }
        return port;
    }

    public Optional<Integer> getPredefinedPort() {
        Integer predefinedPort;
        try {
            predefinedPort = Integer.parseInt(System.getProperty(MUNIT_SERVER_PORT));
        }
        catch (NumberFormatException e) {
            predefinedPort = null;
        }
        return Optional.ofNullable(predefinedPort);
    }

    public Integer findFreePort() {
        FreePortFinder freePortFinder = new FreePortFinder(60000, 60500);
        return freePortFinder.find();
    }

    private Integer getAndSetFreePort() {
        Integer port = this.findFreePort();
        System.setProperty(MUNIT_SERVER_PORT, port.toString());
        return port;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isPortAvailable(int port) {
        try (ServerSocket ignored = new ServerSocket(port);){
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }
}

