/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.event;

import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.model.TypedKeyValue;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.DataTypeParamsBuilder;

public class DataTypeBuilder {
    private Object value;
    private String encoding;
    private String mediaType;

    public static DataTypeBuilder fromTypedKeyValue(TypedKeyValue typedKeyValue) {
        DataTypeBuilder builder = new DataTypeBuilder();
        builder.value(typedKeyValue.getValue());
        builder.encoding(typedKeyValue.getEncoding());
        builder.mediaType(typedKeyValue.getMediaType());
        return builder;
    }

    public DataType build() {
        DataTypeParamsBuilder dataTypeParamsBuilder = DataType.builder().fromObject(this.value);
        if (StringUtils.isNotBlank((CharSequence)this.mediaType)) {
            dataTypeParamsBuilder = dataTypeParamsBuilder.mediaType(this.mediaType);
        }
        dataTypeParamsBuilder = dataTypeParamsBuilder.charset(this.encoding);
        return dataTypeParamsBuilder.build();
    }

    public DataTypeBuilder value(Object value) {
        this.value = value;
        return this;
    }

    public DataTypeBuilder encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public DataTypeBuilder mediaType(String mediaType) {
        this.mediaType = mediaType;
        return this;
    }
}

