/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.util;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class StackTraceUtil {
    public static final String MUNIT_VERBOSE_EXCEPTIONS = "munit.verbose.exceptions";
    private static final int STACKTRACE_LIMIT = 5;

    public static String getStackTrace(Throwable throwable) {
        if (throwable instanceof AssertionError) {
            if (Boolean.parseBoolean(System.getProperty(MUNIT_VERBOSE_EXCEPTIONS))) {
                return ExceptionUtils.getStackTrace((Throwable)throwable);
            }
            return StackTraceUtil.decreaseStackTraceVerbosity(throwable);
        }
        return ExceptionUtils.getStackTrace((Throwable)throwable);
    }

    private static String decreaseStackTraceVerbosity(Throwable throwable) {
        List<StackTraceElement> originalStackTrace = Arrays.asList(throwable.getStackTrace());
        throwable.setStackTrace((StackTraceElement[])originalStackTrace.stream().limit(5L).toArray(StackTraceElement[]::new));
        return ExceptionUtils.getStackTrace((Throwable)throwable);
    }
}

