/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.processor.interceptor;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleEvent;
import org.mule.munit.common.processor.interceptor.MessageProcessorAttributeFilter;
import org.mule.util.AttributeEvaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageProcessorAttributesEvaluator {
    protected static Map<String, Object> getEvaluatedAttributes(Object originalMp, Map<String, String> attributes, MuleEvent event) {
        Map<String, String> filteredAttributes = MessageProcessorAttributeFilter.filterAttributes(originalMp, attributes);
        HashMap<String, Object> processed = new HashMap<String, Object>();
        for (Map.Entry<String, String> attrs : filteredAttributes.entrySet()) {
            try {
                Object evaluate = MessageProcessorAttributesEvaluator.evaluate(attrs.getValue(), event);
                processed.put(attrs.getKey(), evaluate);
            }
            catch (Throwable t) {
                processed.put(attrs.getKey(), attrs.getValue());
            }
        }
        return processed;
    }

    private static Object evaluate(String elementValue, MuleEvent event) {
        Object o;
        Object compareTo = elementValue;
        AttributeEvaluator attributeEvaluator = MessageProcessorAttributesEvaluator.getAttributeEvaluator(elementValue, event);
        if (attributeEvaluator.isExpression() || attributeEvaluator.isParseExpression()) {
            compareTo = attributeEvaluator.resolveValue(event);
        } else if (!StringUtils.isEmpty((String)elementValue) && (o = event.getMuleContext().getRegistry().lookupObject(elementValue)) != null) {
            compareTo = o;
        }
        return compareTo;
    }

    private static AttributeEvaluator getAttributeEvaluator(String attributeValue, MuleEvent event) {
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator(attributeValue);
        attributeEvaluator.initialize(event.getMuleContext().getExpressionManager());
        return attributeEvaluator;
    }
}

