/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.adapters;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DataType;
import org.mule.api.transport.PropertyScope;
import org.mule.munit.common.exception.MunitError;

public class MuleMessageDataTypeSetterAdapter {
    private static final String SET_PAYLOAD_METHOD = "setPayload";
    private static final String SET_PROPERTY_METHOD = "setProperty";
    private transient Log logger = LogFactory.getLog(this.getClass());
    private MuleMessage muleMessage;

    public MuleMessageDataTypeSetterAdapter(MuleMessage defaultMuleMessage) {
        this.muleMessage = defaultMuleMessage;
    }

    public void setPayload(Object payload, DataType dataType) {
        try {
            Method method = this.muleMessage.getClass().getMethod(SET_PAYLOAD_METHOD, Object.class, DataType.class);
            method.invoke((Object)this.muleMessage, payload, dataType);
        }
        catch (NoSuchMethodException e) {
            this.muleMessage.setPayload(payload);
        }
        catch (InvocationTargetException e) {
            throw new MunitError("Fail to invoke setPayload method from " + this.getClass().getSimpleName(), e);
        }
        catch (IllegalAccessException e) {
            throw new MunitError("Fail to invoke setPayload method from " + this.getClass().getSimpleName(), e);
        }
    }

    public void setProperty(String key, Object value, PropertyScope scope, DataType dataType) {
        try {
            Method method = this.muleMessage.getClass().getMethod(SET_PROPERTY_METHOD, String.class, Object.class, PropertyScope.class, DataType.class);
            method.invoke((Object)this.muleMessage, key, value, scope, dataType);
        }
        catch (NoSuchMethodException e) {
            this.muleMessage.setProperty(key, value, scope);
        }
        catch (InvocationTargetException e) {
            throw new MunitError("Fail to invoke setProperty method from " + this.getClass().getSimpleName(), e);
        }
        catch (IllegalAccessException e) {
            throw new MunitError("Fail to invoke setProperty method from " + this.getClass().getSimpleName(), e);
        }
    }
}

