/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.assertion.internal.matchers;



import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.mule.runtime.api.metadata.TypedValue;

import java.nio.charset.Charset;
import java.util.Optional;

/**
 * A TypedValueMatcher that uses a hamcrest matchers to perform an assertion over the encoding of a typed value
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class EncodingMatcher extends TypedValueMatcher {

  private Matcher nestedMatcher;

  public EncodingMatcher(Matcher nestedMatcher) {
    this.nestedMatcher = nestedMatcher;
  }

  @Override
  public boolean doMatch(TypedValue typedValue) {
    return nestedMatcher.matches(getCharset(typedValue));
  }

  @Override
  public void describeMismatch(Object item, Description description) {
    super.describeMismatch(getCharset((TypedValue) item), description);
  }

  @Override
  public void describeTo(Description description) {
    nestedMatcher.describeTo(description);
  }

  private Charset getCharset(TypedValue typedValue) {
    Optional<Charset> charset = typedValue.getDataType().getMediaType().getCharset();
    return charset.isPresent() ? charset.get() : null;
  }

  @Override
  public Matcher<Object> toPlainValueMatcher() {
    throw new IllegalStateException("Encoding Matcher cannot be compared to a value");
  }
}

