/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.assertion.api;

import java.nio.charset.Charset;

import org.mule.runtime.api.metadata.MediaType;

/**
 * <p>
 * Typed Value model to avoid exposing the user the mule api TypedValue
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class TypedValue {

  private Object value;
  private String mediaType;
  private Charset charset;

  public Object getValue() {
    return value;
  }

  public String getMediaType() {
    return mediaType;
  }

  public Charset getCharset() {
    return charset;
  }

  protected TypedValue(Object value, String mediaType, Charset charset) {
    this.value = value;
    this.mediaType = mediaType;
    this.charset = charset;
  }

  public static TypedValue fromMuleTypedValue(org.mule.runtime.api.metadata.TypedValue typedValue) {
    MediaType mediaType = typedValue.getDataType().getMediaType();
    return new TypedValue(typedValue.getValue(),
                          mediaType.withoutParameters().toRfcString(),
                          mediaType.getCharset().orElse(null));
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    TypedValue that = (TypedValue) o;

    return (value != null ? value.equals(that.value) : that.value == null) && mediaType.equals(that.mediaType)
        && (charset != null ? charset.equals(that.charset) : that.charset == null);
  }

  @Override
  public int hashCode() {
    int result = value != null ? value.hashCode() : 0;
    result = 31 * result + mediaType.hashCode();
    result = 31 * result + (charset != null ? charset.hashCode() : 0);
    return result;
  }
}
