/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.assertion.internal.matchers;



import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

/**
 * A Hamcrest {@link Matcher} that checks if a String matches a regular expression
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class RegexMatcher extends TypeSafeMatcher<String> {

  private final String regex;

  public RegexMatcher(String regex) {
    this.regex = regex;
  }

  @Override
  public void describeTo(final Description description) {
    description.appendText("matches regex=`" + regex + "`");
  }

  @Override
  public boolean matchesSafely(final String string) {
    return string.matches(regex);
  }

}
