/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.assertion.internal;

import java.nio.charset.Charset;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matchers;
import org.mule.munit.assertion.api.matchers.Matcher;
import org.mule.munit.assertion.internal.matchers.CallbackMatcher;
import org.mule.munit.assertion.internal.matchers.EncodingMatcher;
import org.mule.munit.assertion.internal.matchers.MediaTypeMatcher;
import org.mule.munit.assertion.internal.matchers.RegexMatcher;
import org.mule.munit.assertion.internal.matchers.TypedValueMatcher;
import org.mule.munit.assertion.internal.matchers.ValueMatcher;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;

public class HamcrestFactory {
    public static org.hamcrest.Matcher<TypedValue> create(Matcher munitMatcher) {
        switch (munitMatcher.getType()) {
            case "equalTo": 
            case "nullValue": 
            case "notNullValue": {
                return new CallbackMatcher((Function)munitMatcher.getExpected()[0]);
            }
            case "not": {
                return CoreMatchers.not(HamcrestFactory.create((Matcher)munitMatcher.getExpected()[0]));
            }
            case "both": {
                return CoreMatchers.allOf(HamcrestFactory.create((Matcher)munitMatcher.getExpected()[0]), HamcrestFactory.create((Matcher)munitMatcher.getExpected()[1]));
            }
            case "either": {
                return CoreMatchers.anyOf(HamcrestFactory.create((Matcher)munitMatcher.getExpected()[0]), HamcrestFactory.create((Matcher)munitMatcher.getExpected()[1]));
            }
            case "withEncoding": {
                String charset = (String)munitMatcher.getExpected()[0];
                return new EncodingMatcher(CoreMatchers.equalTo((Object)(charset == null ? null : Charset.forName(charset))));
            }
            case "withMediaType": {
                String mediaType = (String)munitMatcher.getExpected()[0];
                return new MediaTypeMatcher(mediaType == null ? null : MediaType.parse((String)mediaType));
            }
            case "allOf": {
                return CoreMatchers.allOf((Iterable)Stream.of(munitMatcher.getExpected()).map(matcher -> (Matcher)matcher).map(HamcrestFactory::create).collect(Collectors.toList()));
            }
            case "anyOf": {
                return CoreMatchers.anyOf((Iterable)Stream.of(munitMatcher.getExpected()).map(matcher -> (Matcher)matcher).map(HamcrestFactory::create).collect(Collectors.toList()));
            }
            case "matches": {
                return new ValueMatcher((org.hamcrest.Matcher)new RegexMatcher((String)munitMatcher.getExpected()[0]));
            }
            case "containsString": {
                return new ValueMatcher(CoreMatchers.containsString((String)((String)munitMatcher.getExpected()[0])));
            }
            case "startsWith": {
                return new ValueMatcher(CoreMatchers.startsWith((String)((String)munitMatcher.getExpected()[0])));
            }
            case "endsWith": {
                return new ValueMatcher(CoreMatchers.endsWith((String)((String)munitMatcher.getExpected()[0])));
            }
            case "isEmptyString": {
                return new ValueMatcher(Matchers.isEmptyString());
            }
            case "isEmptyOrNullString": {
                return new ValueMatcher(Matchers.isEmptyOrNullString());
            }
            case "equalToIgnoringCase": {
                return new ValueMatcher(Matchers.equalToIgnoringCase((String)((String)munitMatcher.getExpected()[0])));
            }
            case "equalToIgnoringWhiteSpace": {
                return new ValueMatcher(Matchers.equalToIgnoringWhiteSpace((String)((String)munitMatcher.getExpected()[0])));
            }
            case "stringContainsInOrder": {
                return new ValueMatcher(Matchers.stringContainsInOrder((Iterable)((Iterable)munitMatcher.getExpected()[0])));
            }
            case "greaterThan": {
                return new ValueMatcher(Matchers.greaterThan((Comparable)((Comparable)munitMatcher.getExpected()[0])));
            }
            case "greaterThanOrEqualTo": {
                return new ValueMatcher(Matchers.greaterThanOrEqualTo((Comparable)((Comparable)munitMatcher.getExpected()[0])));
            }
            case "lessThan": {
                return new ValueMatcher(Matchers.lessThan((Comparable)((Comparable)munitMatcher.getExpected()[0])));
            }
            case "lessThanOrEqualTo": {
                return new ValueMatcher(Matchers.lessThanOrEqualTo((Comparable)((Comparable)munitMatcher.getExpected()[0])));
            }
            case "closeTo": {
                return new ValueMatcher(Matchers.closeTo((double)((Number)munitMatcher.getExpected()[0]).doubleValue(), (double)((Number)munitMatcher.getExpected()[1]).doubleValue()));
            }
            case "everyItem": {
                return new ValueMatcher(CoreMatchers.everyItem(HamcrestFactory.toPlainMatcher(HamcrestFactory.create((Matcher)munitMatcher.getExpected()[0]))));
            }
            case "hasItem": {
                return new ValueMatcher(CoreMatchers.hasItem(HamcrestFactory.toPlainMatcher(HamcrestFactory.create((Matcher)munitMatcher.getExpected()[0]))));
            }
            case "hasSize": {
                return new ValueMatcher(Matchers.hasSize(HamcrestFactory.toPlainMatcher(HamcrestFactory.create((Matcher)munitMatcher.getExpected()[0]))));
            }
            case "isEmpty": {
                return new ValueMatcher(Matchers.empty());
            }
            case "hasKey": {
                return new ValueMatcher(Matchers.hasKey(HamcrestFactory.toPlainMatcher(HamcrestFactory.create((Matcher)munitMatcher.getExpected()[0]))));
            }
            case "hasValue": {
                return new ValueMatcher(Matchers.hasValue(HamcrestFactory.toPlainMatcher(HamcrestFactory.create((Matcher)munitMatcher.getExpected()[0]))));
            }
        }
        throw new IllegalArgumentException("Unknown Matcher: " + munitMatcher.getType());
    }

    private static org.hamcrest.Matcher<Object> toPlainMatcher(org.hamcrest.Matcher<TypedValue> typedValueMatcher) {
        if (typedValueMatcher instanceof TypedValueMatcher) {
            return ((TypedValueMatcher)typedValueMatcher).toPlainValueMatcher();
        }
        throw new IllegalArgumentException("The provided matcher should only be applicable for the value of TypedValue");
    }
}

