/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.assertion.processors;

import org.apache.commons.lang.StringUtils;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.munit.common.MunitCore;
import org.mule.munit.common.exception.MunitError;

import static junit.framework.Assert.assertEquals;
import static junit.framework.Assert.fail;


/**
 * <p>
 * The Test Flow
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 3.3.2
 */
public class MunitTestFlow extends MunitFlow {

    /**
     * <p>Determines if the test has to be ignored</p>
     */
    private boolean ignore;

    /**
     * <p>The name of the exception that is expected</p>
     */
    private String expectExceptionThatSatisfies;

    public MunitTestFlow(String name, MuleContext muleContext) {
        super(name, muleContext);

        registerMpManager(muleContext);
    }

    public String getExpectException() {
        return expectExceptionThatSatisfies;
    }

    public void setExpectException(String expectException) {
        this.expectExceptionThatSatisfies = expectException;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public boolean isIgnore() {
        return ignore;
    }

    private boolean expectException(Throwable t) {

        String className = t.getClass().getName();
        if (t instanceof MessagingException) {
            Throwable causeException;
            try {
                causeException = ((MessagingException) t).getCauseException();
            } catch (ClassCastException e) {
                causeException = t.getCause();
            }

            if (causeException != null) {
                className = causeException.getClass().getName();
            }
        }
        assertEquals(expectExceptionThatSatisfies, className);
        return true;
    }


    public boolean expectException(Throwable t, MuleEvent event) {

        if (!StringUtils.isEmpty(expectExceptionThatSatisfies)) {
            ExpressionManager expressionManager = muleContext.getExpressionManager();
            if (expressionManager.isExpression(expectExceptionThatSatisfies)) {

                Object expressionResult;
                try {
                    expressionResult = expressionManager.evaluate(expectExceptionThatSatisfies, event);
                } catch (ExpressionRuntimeException e) {
                    throw new MunitError("Expect exception expression error. " + e.getMessage());
                }

                if (!Boolean.class.isAssignableFrom(expressionResult.getClass())) {
                    fail("The exception does not match your MEL expression. Please make sure your expression matching returns a boolean value");
                }

                Boolean booleanExpressionResult = (Boolean) expressionResult;
                if (!booleanExpressionResult) {
                    fail("The exception does not match your MEL expression");
                }
                return true;


            } else {
                return expectException(t);
            }

        }

        return false;
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {

        MuleEvent process = super.process(event);
        return process;


    }

    private void registerMpManager(MuleContext muleContext) {
        MunitCore.registerManager(muleContext);
    }


}
