/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.assertion.processors;

import org.mule.api.MuleMessage;
import org.mule.munit.assertion.AssertModule;


/**
 * <p>
 * Assert not Same message processor
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 3.3.2
 */
public class AssertNotSameMessageProcessor extends MunitMessageProcessor {

    /**
     * @see AssertModule#assertNotSame(String, Object, Object)
     */
    private String message;

    /**
     * @see AssertModule#assertNotSame(String, Object, Object)
     */
    private Object expected;

    /**
     * @see AssertModule#assertNotSame(String, Object, Object)
     */
    private Object value;

    /**
     * @see MunitMessageProcessor#doProcess(org.mule.api.MuleMessage, org.mule.munit.assertion.AssertModule)
     */
    @Override
    protected void doProcess(MuleMessage mulemessage, AssertModule module) {
        String message = this.message == null ? null : evaluate(mulemessage, this.message).toString();
        module.assertNotSame(message, evaluate(mulemessage, expected), evaluate(mulemessage, value));
    }

    /**
     * @see MunitMessageProcessor#getProcessor()
     */
    @Override
    protected String getProcessor() {
        return "assertNotSame";
    }

    public void setMessage(String value) {
        this.message = value;
    }

    public void setExpectedValue(Object expectedValue) {
        this.expected = expectedValue;
    }

    public void setActualValue(Object actualValue) {
        this.value = actualValue;
    }

}
