/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.assertion.processors;

import org.mule.api.MuleMessage;
import org.mule.munit.assertion.AssertModule;


/**
 * <p>
 * Assert Not null message processor
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 3.3.2
 */
public class AssertNotNullMessageProcessor extends MunitMessageProcessor {

    /**
     * @see AssertModule#assertNotNull(String, Object)
     */
    private String message;

    public void setMessage(String value) {
        this.message = value;
    }

    /**
     * @see MunitMessageProcessor#doProcess(org.mule.api.MuleMessage, org.mule.munit.assertion.AssertModule)
     */
    @Override
    protected void doProcess(MuleMessage mulemessage, AssertModule module) {
        String message = this.message == null ? null : evaluate(mulemessage, this.message).toString();
        module.assertNotNull(message, mulemessage.getPayload());
    }

    /**
     * @see MunitMessageProcessor#getProcessor()
     */
    @Override
    protected String getProcessor() {
        return "assertNotNull";
    }

}
