/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mtf.tools.internal.tooling.values.model;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.value.Value;

public class ValuesAdapter {
    private final Value value;

    private ValuesAdapter(Value value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"Value cannot be null");
        this.value = value;
    }

    public static Map<String, ValuesAdapter> convertToMap(Set<Value> values) {
        return values.stream().collect(Collectors.toMap(Value::getId, ValuesAdapter::new));
    }

    public String getId() {
        return this.value.getId();
    }

    public String getDisplayName() {
        return this.value.getDisplayName();
    }

    public String getPartName() {
        return this.value.getPartName();
    }

    public Map<String, ValuesAdapter> getChilds() {
        return ValuesAdapter.convertToMap(this.value.getChilds());
    }

    public String toString() {
        return this.value.toString();
    }
}

