/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mtf.tools.internal.tooling.values;

import org.mule.munit.mtf.tools.internal.tooling.exception.ToolingTestException;
import org.mule.munit.mtf.tools.internal.tooling.values.GetValuesScope;
import org.mule.munit.mtf.tools.internal.tooling.values.model.ValuesAdapter;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.value.ResolvingFailure;
import org.mule.runtime.api.value.ValueResult;

public class GetValuesFromConfig
extends GetValuesScope {
    @Override
    public Message getMessage() throws ToolingTestException {
        ValueResult configurationResult = this.valueProviderService.getValues(this.getConfigurationLocation(), this.parameter);
        if (configurationResult.isSuccess()) {
            return Message.of(ValuesAdapter.convertToMap(configurationResult.getValues()));
        }
        ValueResult connectionResult = this.valueProviderService.getValues(this.getConnectionLocation(), this.parameter);
        if (connectionResult.isSuccess()) {
            return Message.of(ValuesAdapter.convertToMap(connectionResult.getValues()));
        }
        ResolvingFailure configurationFailure = this.getFailure(configurationResult);
        if (configurationFailure.getFailureCode().equals("INVALID_VALUE_RESOLVER_NAME")) {
            throw this.newToolingException(this.getFailure(connectionResult));
        }
        throw this.newToolingException(configurationFailure);
    }

    @Override
    public void initialise() {
    }

    @Override
    public void dispose() {
    }

    private ToolingTestException newToolingException(ResolvingFailure failure) {
        return new ToolingTestException(failure.getMessage(), failure.getFailureCode(), failure.getReason());
    }

    private Location getConfigurationLocation() {
        return this.getComponentLocation();
    }

    private Location getConnectionLocation() {
        return Location.builderFromStringRepresentation((String)this.getComponentLocation().toString()).addConnectionPart().build();
    }

    private ResolvingFailure getFailure(ValueResult configurationResult) {
        return (ResolvingFailure)configurationResult.getFailure().orElseThrow(() -> new IllegalStateException("Getting values was unsuccessful but no failure was provided"));
    }
}

