/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mtf.tools.internal.tooling;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.mtf.tools.internal.tooling.ToolingComponent;
import org.mule.munit.mtf.tools.internal.tooling.exception.ToolingTestException;
import org.mule.munit.runner.component.TestComponent;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.privileged.PrivilegedMuleContext;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolingTest
extends AbstractComponent
implements TestComponent,
Lifecycle {
    private static Logger LOGGER = LoggerFactory.getLogger(ToolingTest.class);
    private static final String TAG_SEPARATOR = ",";
    @Inject
    protected PrivilegedMuleContext muleContext;
    private boolean ignore;
    private String name;
    private String description;
    private String tags;
    private String expectFailureCode;
    private String expectFailureMessage;
    private ToolingComponent toolingComponent;
    private MessageProcessorChain validation;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExpectFailureCode() {
        return this.expectFailureCode;
    }

    public String getExpectFailureMessage() {
        return this.expectFailureMessage;
    }

    public void setExpectFailureMessage(String expectFailureMessage) {
        this.expectFailureMessage = expectFailureMessage;
    }

    public void setExpectFailureCode(String expectFailureCode) {
        this.expectFailureCode = expectFailureCode;
    }

    public Event run(Event event) throws Throwable {
        CoreEvent incomingEvent = (CoreEvent)event;
        CoreEvent eventWithToolingData = this.processToolingData(incomingEvent);
        if (this.validation != null) {
            return this.validation.process(eventWithToolingData);
        }
        return eventWithToolingData;
    }

    private CoreEvent processToolingData(CoreEvent incomingEvent) throws ToolingTestException {
        CoreEvent eventWithToolingData = incomingEvent;
        try {
            if (this.toolingComponent != null) {
                eventWithToolingData = this.toolingComponent.process(incomingEvent);
            }
            this.expectedButDidNotFail();
        }
        catch (ToolingTestException e) {
            if (this.isExpectingFailure()) {
                this.expectFailure(e);
            }
            throw e;
        }
        return eventWithToolingData;
    }

    private void expectedButDidNotFail() {
        if (this.isExpectingFailure()) {
            String expectedMessage = "";
            if (StringUtils.isNotBlank((CharSequence)this.expectFailureCode)) {
                expectedMessage = expectedMessage + " with the failure code: " + this.expectFailureCode;
            }
            if (StringUtils.isNotBlank((CharSequence)this.expectFailureMessage)) {
                if (!StringUtils.isEmpty((CharSequence)expectedMessage)) {
                    expectedMessage = expectedMessage + " and";
                }
                expectedMessage = expectedMessage + " with the message: " + this.expectFailureMessage;
            }
            throw new AssertionError((Object)("Test was expecting to fail" + expectedMessage + " but no error was thrown"));
        }
    }

    private boolean isExpectingFailure() {
        return StringUtils.isNotBlank((CharSequence)this.expectFailureCode) || StringUtils.isNotBlank((CharSequence)this.expectFailureMessage);
    }

    private void expectFailure(ToolingTestException e) {
        String actualFailureMessage;
        String actualFailureCode;
        String errorMessage = "";
        if (StringUtils.isNotBlank((CharSequence)this.expectFailureCode) && !(actualFailureCode = e.getFailureCode()).equals(this.expectFailureCode)) {
            errorMessage = errorMessage + " failure code [" + this.expectFailureCode + "] but was [" + actualFailureCode + "]";
        }
        if (StringUtils.isNotBlank((CharSequence)this.expectFailureMessage) && !(actualFailureMessage = e.getFailureMessage()).contains(this.expectFailureMessage)) {
            if (!StringUtils.isEmpty((CharSequence)errorMessage)) {
                errorMessage = errorMessage + " and";
            }
            errorMessage = errorMessage + " error message [" + this.expectFailureMessage + "] but was [" + actualFailureMessage + "]";
        }
        if (!StringUtils.isEmpty((CharSequence)errorMessage)) {
            throw new AssertionError((Object)("Expected" + errorMessage));
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<String> getTags() {
        if (StringUtils.isBlank((CharSequence)this.tags)) {
            return Collections.emptySet();
        }
        Set<String> tagSet = Stream.of(this.tags.split(TAG_SEPARATOR)).collect(Collectors.toSet());
        if (tagSet.stream().anyMatch(tag -> tag.trim().equalsIgnoreCase("NO_TAG"))) {
            throw new IllegalArgumentException("The tag 'NO_TAG' is invalid since it's a keyword.");
        }
        return tagSet;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public boolean isIgnored() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public ToolingComponent getToolingComponent() {
        return this.toolingComponent;
    }

    public void setToolingComponent(ToolingComponent toolingComponent) {
        this.toolingComponent = toolingComponent;
    }

    public void setValidation(MessageProcessorChain validation) {
        this.validation = validation;
    }

    public MessageProcessorChain getValidation() {
        return this.validation;
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.toolingComponent);
        LifecycleUtils.stopIfNeeded((Object)this.validation);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.toolingComponent, (Logger)LOGGER);
        LifecycleUtils.disposeIfNeeded((Object)this.validation, (Logger)LOGGER);
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded((Object)this.toolingComponent);
        LifecycleUtils.startIfNeeded((Object)this.validation);
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.toolingComponent, (MuleContext)this.muleContext);
        LifecycleUtils.initialiseIfNeeded((Object)this.validation, (MuleContext)this.muleContext);
    }
}

