/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.plugin.classloader;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ClassLoaderInjectorInvocationHandler
implements InvocationHandler {
    private final ClassLoader classLoader;
    private final Object delegate;

    public ClassLoaderInjectorInvocationHandler(Object delegate, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            Object object = method.invoke(this.delegate, args);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalLoader);
        }
    }

    public static Object createProxy(Object delegate, ClassLoader classLoader, Class<?>[] interfaces) {
        ClassLoaderInjectorInvocationHandler handler = new ClassLoaderInjectorInvocationHandler(delegate, classLoader);
        return Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)handler);
    }
}

