/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.serialization.kryo.internal;

import com.esotericsoftware.kryo.ClassResolver;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.ReferenceResolver;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.StreamFactory;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.kryo.util.DefaultStreamFactory;
import com.esotericsoftware.kryo.util.MapReferenceResolver;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.util.InputBaseDecorator;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.util.FunctionalUtils;
import org.mule.runtime.api.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ExternalizableKryo
extends Kryo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalizableKryo.class);
    private static final String FILED_SERIALIZER_CREATION_FAILURE_MESSAGE = "Unable to create serializer \"" + FieldSerializer.class.getName() + "\"";
    private static final String FIELD_SERIALIZER_CREATION_FAILURE_WARNING_FORMAT = "Reflective operation exception found when creating an implicit reflection serializer for class '{}'. We'll search a serializer for the parent class if possible";
    private Class<?> classBeingRegistered = null;
    private final Map<Class<?>, Registration> class2Registration = new HashMap();

    public ExternalizableKryo(ClassResolver classResolver) {
        super(classResolver, (ReferenceResolver)new MapReferenceResolver(), (StreamFactory)new DefaultStreamFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Registration register(Class type, Serializer serializer) {
        this.classBeingRegistered = type;
        try {
            Registration registration = super.register(type, serializer);
            return registration;
        }
        finally {
            this.classBeingRegistered = null;
        }
    }

    public int getNextRegistrationId() {
        Preconditions.checkState((this.classBeingRegistered != null ? 1 : 0) != 0, (String)"Cannot generate an id while no class is being registered");
        return Math.abs(this.classBeingRegistered.getCanonicalName().hashCode());
    }

    protected Class<?> getClassBeingRegistered() {
        return this.classBeingRegistered;
    }

    public Registration getRegistration(Class type) {
        return (Registration)FunctionalUtils.computeIfAbsent(this.class2Registration, (Object)type, c -> {
            Registration registration = null;
            Class searchType = type;
            while (registration == null && this.isRecurseRegistrationSearch(searchType)) {
                registration = this.getExplicitRegistrationOrNull(searchType);
                searchType = searchType.getSuperclass();
            }
            if (registration == null) {
                Class<?> iFace;
                Class<?>[] classArray = type.getInterfaces();
                int n = classArray.length;
                for (int i = 0; i < n && (registration = this.getRegistration(iFace = classArray[i])).getId() == -1; ++i) {
                    registration = null;
                }
            }
            return registration != null ? registration : super.getRegistration(type);
        });
    }

    public Registration getRegistration(int classID) {
        return super.getRegistration(Math.abs(classID));
    }

    public Registration readClass(Input input) {
        return super.readClass(this.decorateInput(input));
    }

    private Input decorateInput(Input input) {
        return new InputBaseDecorator(input){
            private boolean alreadyRead;
            {
                this.alreadyRead = false;
            }

            @Override
            public int readVarInt(boolean optimizePositive) throws KryoException {
                if (this.alreadyRead) {
                    return super.readVarInt(optimizePositive);
                }
                this.alreadyRead = true;
                int classId = super.readVarInt(optimizePositive);
                if (classId < 0) {
                    return Math.abs(classId) + 4;
                }
                return classId;
            }
        };
    }

    private Registration getExplicitRegistrationOrNull(Class<?> searchType) {
        try {
            Registration registration = super.getRegistration(searchType);
            if (registration.getId() == -1) {
                return null;
            }
            return registration;
        }
        catch (IllegalArgumentException exception) {
            if (this.failedTryingToCreateFieldSerializer(exception)) {
                this.logFieldSerializerCreationFailureWarning(searchType, exception);
                return null;
            }
            throw exception;
        }
    }

    private void logFieldSerializerCreationFailureWarning(Class<?> searchType, IllegalArgumentException exception) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(FIELD_SERIALIZER_CREATION_FAILURE_WARNING_FORMAT, (Object)searchType.getName(), (Object)exception);
        } else {
            LOGGER.warn(FIELD_SERIALIZER_CREATION_FAILURE_WARNING_FORMAT, (Object)searchType.getName());
        }
    }

    private boolean failedTryingToCreateFieldSerializer(IllegalArgumentException exception) {
        Throwable cause = exception.getCause();
        return cause instanceof ReflectiveOperationException && exception.getMessage().startsWith(FILED_SERIALIZER_CREATION_FAILURE_MESSAGE);
    }

    private <T> boolean isRecurseRegistrationSearch(Class<T> searchType) {
        return searchType != null && !Enum.class.isAssignableFrom(searchType) && !Object.class.equals(searchType);
    }
}

