/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.security;

import java.util.Arrays;
import java.util.List;
import javax.crypto.spec.SecretKeySpec;
import org.mule.encryption.Encrypter;
import org.mule.encryption.jce.JCEEncrypter;
import org.mule.encryption.key.EncryptionKeyFactory;
import org.mule.encryption.key.SymmetricKeyFactory;

public class NodeSecurityManager {
    public static final String PROPERTY_SECURITY_MODEL = "mule.security.model";
    private static final List<String> FIPS_SECURITY_MODELS = Arrays.asList("fips140-2");
    public static final String DEFAULT_ENCRYPTION_TRANSFORMATION = "AES/GCM/NoPadding";
    private boolean isFipsEnabled = FIPS_SECURITY_MODELS.contains(System.getProperty("mule.security.model"));
    private String encryptionKey = System.getProperty("mule.cluster.network.encryption.key", null);
    private final String encryptionTransformation = System.getProperty("mule.cluster.network.encryption.transformation", "AES/GCM/NoPadding");

    public boolean isFipsEnabled() {
        return this.isFipsEnabled;
    }

    public synchronized Encrypter getEncrypter() {
        if (!this.isFipsEnabled()) {
            throw new IllegalArgumentException("Cluster network encryption should be used only when in FIPS mode.");
        }
        if (this.encryptionKey == null) {
            throw new IllegalArgumentException("Cluster network encryption key must be defined when in FIPS mode. Define the mule.cluster.network.encryption.key property.");
        }
        SymmetricKeyFactory keyFactory = () -> new SecretKeySpec(this.encryptionKey.getBytes(), this.getEncryptionAlgorithmName(this.encryptionTransformation));
        return new JCEEncrypter(this.encryptionTransformation, (EncryptionKeyFactory)keyFactory);
    }

    private String getEncryptionAlgorithmName(String encryptionTransformation) {
        return encryptionTransformation.split("/", 1)[0];
    }

    public void setFipsEnabled(boolean fipsEnabled) {
        this.isFipsEnabled = fipsEnabled;
    }

    public void setKey(String key) {
        this.encryptionKey = key;
    }
}

