/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.cp.lock.FencedLock;
import com.mulesoft.mule.runtime.module.cluster.api.ClusterLocker;
import com.mulesoft.mule.runtime.module.cluster.internal.boot.notification.PrimaryClusterNodeNotifier;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastClusterLocker
extends Thread
implements ClusterLocker {
    private static final Logger LOGGER = LoggerFactory.getLogger(HazelcastClusterLocker.class);
    public static final String PRIMARY_SERVER_LOCK_ID = "mule.polling.locked.object";
    private final HazelcastInstance hazelcastInstance;
    private final String lockName;
    private final PrimaryClusterNodeNotifier primaryClusterNodeNotifier;
    private final int heartbeatTimeoutSecs;
    private final Object pollingNodeLock = new Object();

    public HazelcastClusterLocker(String lockId, HazelcastInstance hazelcastInstance, PrimaryClusterNodeNotifier primaryClusterNodeNotifier, int heartbeatTimeoutSecs) {
        this.setName("cluster.poller");
        this.setDaemon(true);
        this.lockName = lockId;
        this.hazelcastInstance = hazelcastInstance;
        this.primaryClusterNodeNotifier = primaryClusterNodeNotifier;
        this.heartbeatTimeoutSecs = heartbeatTimeoutSecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForNotification() throws InterruptedException {
        Object object = this.pollingNodeLock;
        synchronized (object) {
            FencedLock lock = this.getLock();
            do {
                LOGGER.info("We are now the cluster polling node.");
                this.primaryClusterNodeNotifier.notifyPrimaryClusterNode();
                this.pollingNodeLock.wait();
            } while (lock.isLockedByCurrentThread());
            LOGGER.info("We are no longer the polling node");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyIfPollingNode() {
        Object object = this.pollingNodeLock;
        synchronized (object) {
            this.pollingNodeLock.notifyAll();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        block9: while (true) {
            while (!this.isInterrupted()) {
                try {
                    FencedLock lock = this.getLock();
                    if (!lock.tryLock((long)(this.heartbeatTimeoutSecs / 10), TimeUnit.SECONDS)) continue block9;
                    this.waitForNotification();
                }
                catch (OperationTimeoutException ex) {
                    LOGGER.warn("Timeout locking polling lock", (Throwable)ex);
                }
                catch (InterruptedException ex) {
                    HazelcastClusterLocker.currentThread().interrupt();
                    this.unlock();
                    return;
                }
                catch (Exception ex) {
                    block11: {
                        LOGGER.warn("Exception locking polling lock, retying to get lock");
                        if (!(ex.getCause() instanceof InterruptedException)) break block11;
                        HazelcastClusterLocker.currentThread().interrupt();
                        this.unlock();
                        return;
                    }
                    try {
                        if (!LOGGER.isDebugEnabled()) continue block9;
                        LOGGER.debug(ex.getMessage(), (Throwable)ex);
                        continue block9;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return;
                    }
                }
            }
            break;
        }
        finally {
            this.unlock();
        }
    }

    private void unlock() {
        block3: {
            FencedLock lock = this.getLock();
            try {
                if (lock != null && lock.isLockedByCurrentThread()) {
                    lock.unlock();
                }
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    public FencedLock getLock() {
        return this.hazelcastInstance.getCPSubsystem().getLock(this.lockName);
    }
}

