/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.persistence.query;

import com.mulesoft.mule.runtime.module.cluster.internal.persistence.query.AbstractDatabaseStoreQueryBuilderStrategy;

public class PostgreSqlDatabaseStoreQueryBuilderStrategy
extends AbstractDatabaseStoreQueryBuilderStrategy {
    private static final String CREATE_TABLE_QUERY = "CREATE TABLE \"%s\" (\n\tvalue_key VARCHAR(256) NOT NULL, \n    value_data bytea,\n    PRIMARY KEY (value_key)\n)";
    private static final String STORE_QUERY = "INSERT INTO \"%s\" values (?, ?)";
    private static final String UPDATE_QUERY = "UPDATE \"%s\" SET value_data = ? where value_key = ?";
    private static final String LOAD_ALL_QUERY = "SELECT * FROM \"%s\" WHERE value_key IN ";
    private static final String LOAD_ALL_KEYS_QUERY = "SELECT value_key FROM \"%s\"";
    private static final String LOAD_KEY_QUERY = "SELECT * FROM \"%s\" where value_key = ?";
    private static final String DELETE_QUERY = "DELETE FROM \"%s\" where value_key = ?";
    private static final String DELETE_ALL_QUERY = "DELETE FROM \"%s\" where value_key IN ";
    private static final String TABLE_EXISTENCE_QUERY = "SELECT 1 FROM information_schema.tables WHERE table_name = '%s' ";

    public PostgreSqlDatabaseStoreQueryBuilderStrategy(String fileNameTransformerStrategy) {
        super(fileNameTransformerStrategy);
    }

    @Override
    protected String getCreateTableQueryFormat() {
        return CREATE_TABLE_QUERY;
    }

    @Override
    protected String getStoreQueryFormat() {
        return STORE_QUERY;
    }

    @Override
    public String getUpdateQueryFormat() {
        return UPDATE_QUERY;
    }

    @Override
    protected String getLoadQueryFormat() {
        return LOAD_KEY_QUERY;
    }

    @Override
    protected String getLoadAllQueryFormat() {
        return LOAD_ALL_QUERY;
    }

    @Override
    protected String getLoadAllKeysQueryFormat() {
        return LOAD_ALL_KEYS_QUERY;
    }

    @Override
    protected String getDeleteQueryFormat() {
        return DELETE_QUERY;
    }

    @Override
    protected String getDeleteAllQueryFormatWithoutArray() {
        return DELETE_ALL_QUERY;
    }

    @Override
    protected String getTableExistsQueryFormat() throws UnsupportedOperationException {
        return TABLE_EXISTENCE_QUERY;
    }
}

