/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.api.notification;

import com.mulesoft.mule.runtime.module.batch.api.BatchStep;
import com.mulesoft.mule.runtime.module.batch.api.extension.structure.BatchJobInstance;
import com.mulesoft.mule.runtime.module.batch.api.record.Record;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceAdapter;
import com.mulesoft.mule.runtime.module.batch.internal.ImmutableBatchJobInstance;
import org.mule.runtime.api.notification.CustomNotification;

public final class BatchNotification
extends CustomNotification {
    private static final long serialVersionUID = -2286923542170141883L;
    private static final int BATCH_ACTION_BASE = 300000;
    private static int ACTION_INDEX = 0;
    public static final int LOAD_PHASE_BEGIN = ++ACTION_INDEX + 300000;
    public static final int LOAD_PHASE_PROGRESS = ++ACTION_INDEX + 300000;
    public static final int LOAD_PHASE_END = ++ACTION_INDEX + 300000;
    public static final int LOAD_PHASE_FAILED = ++ACTION_INDEX + 300000;
    public static final int JOB_PROCESS_RECORDS_BEGIN = ++ACTION_INDEX + 300000;
    public static final int JOB_PROCESS_RECORDS_FAILED = ++ACTION_INDEX + 300000;
    public static final int JOB_SUCCESSFUL = ++ACTION_INDEX + 300000;
    public static final int JOB_STOPPED = ++ACTION_INDEX + 300000;
    public static final int JOB_CANCELLED = ++ACTION_INDEX + 300000;
    public static final int ON_COMPLETE_BEGIN = ++ACTION_INDEX + 300000;
    public static final int ON_COMPLETE_END = ++ACTION_INDEX + 300000;
    public static final int ON_COMPLETE_FAILED = ++ACTION_INDEX + 300000;
    public static final int STEP_RECORD_START = ++ACTION_INDEX + 300000;
    public static final int STEP_RECORD_END = ++ACTION_INDEX + 300000;
    public static final int STEP_RECORD_FAILED = ++ACTION_INDEX + 300000;
    public static final int STEP_AGGREGATOR_START = ++ACTION_INDEX + 300000;
    public static final int STEP_AGGREGATOR_END = ++ACTION_INDEX + 300000;
    public static final int STEP_AGGREGATOR_FAILED = ++ACTION_INDEX + 300000;
    public static final int STEP_JOB_END = ++ACTION_INDEX + 300000;
    public static final int PROGRESS_UPDATE = ++ACTION_INDEX + 300000;
    private final BatchJobInstance jobInstance;
    private final BatchStep step;
    private final Exception exception;
    private final Record record;
    private final String correlationId;

    public BatchNotification(BatchJobInstance jobInstance, int action) {
        super(null, action);
        this.jobInstance = this.safe(jobInstance);
        this.correlationId = this.getCorrelationId(jobInstance);
        this.step = null;
        this.exception = null;
        this.record = null;
    }

    public BatchNotification(BatchJobInstance jobInstance, Exception exception, int action) {
        super(null, action);
        this.jobInstance = this.safe(jobInstance);
        this.correlationId = this.getCorrelationId(jobInstance);
        this.exception = exception;
        this.step = null;
        this.record = null;
    }

    public BatchNotification(BatchJobInstance jobInstance, BatchStep step, int action) {
        super(null, action);
        this.jobInstance = this.safe(jobInstance);
        this.correlationId = this.getCorrelationId(jobInstance);
        this.step = step;
        this.exception = null;
        this.record = null;
    }

    public BatchNotification(BatchJobInstance jobInstance, BatchStep step, Record record, int action) {
        super(null, action);
        this.jobInstance = this.safe(jobInstance);
        this.correlationId = this.getCorrelationId(jobInstance);
        this.record = record;
        this.step = step;
        this.exception = null;
    }

    public BatchNotification(BatchJobInstance jobInstance, BatchStep step, Exception e, int action) {
        super(null, action);
        this.jobInstance = this.safe(jobInstance);
        this.correlationId = this.getCorrelationId(jobInstance);
        this.exception = e;
        this.step = step;
        this.record = null;
    }

    public BatchNotification(BatchJobInstance jobInstance, BatchStep step, Record record, Exception e, int action) {
        super(null, action);
        this.jobInstance = this.safe(jobInstance);
        this.correlationId = this.getCorrelationId(jobInstance);
        this.record = record;
        this.exception = e;
        this.step = step;
    }

    private BatchJobInstance safe(BatchJobInstance jobInstance) {
        if (jobInstance instanceof ImmutableBatchJobInstance) {
            return jobInstance;
        }
        return new ImmutableBatchJobInstance(jobInstance);
    }

    public BatchJobInstance getJobInstance() {
        return this.jobInstance;
    }

    public BatchStep getStep() {
        return this.step;
    }

    public Exception getException() {
        return this.exception;
    }

    public Record getRecord() {
        return this.record;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    private String getCorrelationId(BatchJobInstance jobInstance) {
        if (jobInstance instanceof BatchJobInstanceAdapter) {
            return ((BatchJobInstanceAdapter)jobInstance).getBatchEvent().getCorrelationId();
        }
        return null;
    }

    public String toString() {
        return String.format("EVENT: %s {action = %s, BathJob = %s, Instance Id = %s}", this.getEventName(), BatchNotification.getActionName((int)this.action), this.jobInstance.getOwnerJobName(), this.jobInstance.getId());
    }

    public String getEventName() {
        return "BatchNotification";
    }

    static {
        BatchNotification.registerAction((String)"Batch Job Instance started loading phase", (int)LOAD_PHASE_BEGIN);
        BatchNotification.registerAction((String)"Batch Job Instance finished loading phase", (int)LOAD_PHASE_END);
        BatchNotification.registerAction((String)"Batch Job Instance failed to complete the loading phase", (int)LOAD_PHASE_FAILED);
        BatchNotification.registerAction((String)"Batch Job Instance started processing records", (int)JOB_PROCESS_RECORDS_BEGIN);
        BatchNotification.registerAction((String)"Batch Job Instance failed to process records", (int)JOB_PROCESS_RECORDS_FAILED);
        BatchNotification.registerAction((String)"Batch Job Instance finished successfully", (int)JOB_SUCCESSFUL);
        BatchNotification.registerAction((String)"Batch Job Instance has been stopped", (int)JOB_STOPPED);
        BatchNotification.registerAction((String)"Batch Job Instance has been cancelled", (int)JOB_CANCELLED);
        BatchNotification.registerAction((String)"Batch Job Instance started the on-complete phase", (int)ON_COMPLETE_BEGIN);
        BatchNotification.registerAction((String)"Batch Job Instance finished the on-complete phase", (int)ON_COMPLETE_END);
        BatchNotification.registerAction((String)"Batch Job Instance failed in the on-complete phase", (int)ON_COMPLETE_FAILED);
        BatchNotification.registerAction((String)"Batch Step started processing a record for Batch Job Instance", (int)STEP_RECORD_START);
        BatchNotification.registerAction((String)"Batch Step finished processing a record for Batch Job Instance", (int)STEP_RECORD_END);
        BatchNotification.registerAction((String)"Batch Step failed to process a record for Batch Job Instance", (int)STEP_RECORD_FAILED);
        BatchNotification.registerAction((String)"Batch Step started processing its aggregator block", (int)STEP_AGGREGATOR_START);
        BatchNotification.registerAction((String)"Batch Step finished processing its aggregator block", (int)STEP_AGGREGATOR_END);
        BatchNotification.registerAction((String)"Batch Step failed to process its aggregator block", (int)STEP_AGGREGATOR_FAILED);
        BatchNotification.registerAction((String)"Batch Step finished processing all records for Batch Job Instance", (int)STEP_JOB_END);
        BatchNotification.registerAction((String)"Batch Job Instance reports progress", (int)PROGRESS_UPDATE);
    }
}

