/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.wss.internal.handler;

import com.mulesoft.modules.wss.api.store.KeyStoreConfiguration;
import com.mulesoft.modules.wss.api.store.TrustStoreConfiguration;
import java.util.Properties;

public class StoreConfigHandler {
    private StoreConfigHandler() {
    }

    protected static Properties getWssProperties(KeyStoreConfiguration keyStoreConfiguration) {
        String keyPassword;
        String alias;
        String password;
        Properties properties = new Properties();
        properties.put("org.apache.wss4j.crypto.merlin.keystore.file", keyStoreConfiguration.getPath());
        String type = keyStoreConfiguration.getType();
        if (type != null) {
            properties.put("org.apache.wss4j.crypto.merlin.keystore.type", type);
        }
        if ((password = keyStoreConfiguration.getPassword()) != null) {
            properties.put("org.apache.wss4j.crypto.merlin.keystore.password", password);
        }
        if ((alias = keyStoreConfiguration.getAlias()) != null) {
            properties.put("org.apache.wss4j.crypto.merlin.keystore.alias", alias);
        }
        if ((keyPassword = keyStoreConfiguration.getKeyPassword()) != null) {
            properties.put("org.apache.wss4j.crypto.merlin.keystore.private.password", keyPassword);
        }
        return properties;
    }

    protected static Properties getWssProperties(TrustStoreConfiguration trustStoreConfiguration) {
        String password;
        Properties properties = new Properties();
        properties.put("org.apache.wss4j.crypto.merlin.truststore.file", trustStoreConfiguration.getPath());
        String type = trustStoreConfiguration.getType();
        if (type != null) {
            properties.put("org.apache.wss4j.crypto.merlin.truststore.type", type);
        }
        if ((password = trustStoreConfiguration.getPassword()) != null) {
            properties.put("org.apache.wss4j.crypto.merlin.truststore.password", password);
        }
        return properties;
    }
}

