/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.wss.internal.handler;

import com.mulesoft.modules.wss.api.constants.SignatureAlgorithmConstants;
import com.mulesoft.modules.wss.api.constants.SignatureC14nAlgorithmConstants;
import com.mulesoft.modules.wss.api.constants.SignatureDigestAlgorithmConstants;
import com.mulesoft.modules.wss.api.constants.SignatureKeyIdentifierConstants;
import com.mulesoft.modules.wss.api.outbound.BaseOutboundConfig;
import com.mulesoft.modules.wss.api.outbound.EncryptionConfig;
import com.mulesoft.modules.wss.api.outbound.MessagePart;
import com.mulesoft.modules.wss.api.outbound.SignatureConfig;
import com.mulesoft.modules.wss.api.outbound.TimestampConfig;
import com.mulesoft.modules.wss.api.store.KeyStoreConfiguration;
import com.mulesoft.modules.wss.internal.error.WssApplyException;
import com.mulesoft.modules.wss.internal.error.WssException;
import com.mulesoft.modules.wss.internal.error.WssSecurityException;
import com.mulesoft.modules.wss.internal.handler.StoreConfigHandler;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.Merlin;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.message.WSSecTimestamp;
import org.apache.xml.security.Init;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;

public class OutboundConfigHandler {
    private WSSecHeader securityHeader;

    public OutboundConfigHandler(WSSecHeader securityHeader) {
        this.securityHeader = securityHeader;
    }

    public void handle(EncryptionConfig encryptionConfig, ObjectStoreManager runtimeObjectStoreManager, String correlationId) {
        try {
            Init.init();
            WSSecEncrypt wsEncrypt = new WSSecEncrypt(this.securityHeader);
            KeyStoreConfiguration keyStoreConfiguration = encryptionConfig.getKeyStoreConfiguration();
            if (keyStoreConfiguration == null) {
                X509Certificate signReqCertificate = this.getSigningRequestCertificate(correlationId, runtimeObjectStoreManager);
                if (signReqCertificate != null) {
                    wsEncrypt.setUseThisCert(signReqCertificate);
                }
            } else {
                wsEncrypt.setUserInfo(keyStoreConfiguration.getAlias(), keyStoreConfiguration.getKeyPassword());
            }
            if (encryptionConfig.getEncryptionKeyIdentifier() != null) {
                wsEncrypt.setKeyIdentifierType(encryptionConfig.getEncryptionKeyIdentifier().getNumVal());
            }
            wsEncrypt.setSymmetricEncAlgorithm(encryptionConfig.getEncryptionSymAlgorithm().toString());
            wsEncrypt.setKeyEncAlgo(encryptionConfig.getEncryptionKeyTransportAlgorithm().toString());
            wsEncrypt.setDigestAlgorithm(encryptionConfig.getEncryptionDigestAlgorithm().toString());
            List<WSEncryptionPart> wsParts = this.createWSParts(encryptionConfig);
            if (!wsParts.isEmpty()) {
                wsEncrypt.getParts().addAll(wsParts);
            }
            wsEncrypt.build(keyStoreConfiguration != null ? this.getCrypto(keyStoreConfiguration) : null);
        }
        catch (Exception e) {
            throw new WssApplyException(e);
        }
    }

    public void handle(SignatureConfig signatureConfig) {
        try {
            List<WSEncryptionPart> wsParts;
            SignatureDigestAlgorithmConstants digestAlgorithm;
            SignatureC14nAlgorithmConstants c14nAlgorithm;
            SignatureAlgorithmConstants algorithm;
            WSSecSignature wssSign = new WSSecSignature(this.securityHeader);
            KeyStoreConfiguration keyStoreConfiguration = signatureConfig.getKeyStoreConfiguration();
            wssSign.setUserInfo(keyStoreConfiguration.getAlias(), keyStoreConfiguration.getKeyPassword());
            SignatureKeyIdentifierConstants keyIdentifier = signatureConfig.getKeyIdentifier();
            if (keyIdentifier != null) {
                wssSign.setKeyIdentifierType(keyIdentifier.getNumVal());
            }
            if ((algorithm = signatureConfig.getAlgorithm()) != null) {
                wssSign.setSignatureAlgorithm(algorithm.toString());
            }
            if ((c14nAlgorithm = signatureConfig.getC14nAlgorithm()) != null) {
                wssSign.setSigCanonicalization(c14nAlgorithm.toString());
            }
            if ((digestAlgorithm = signatureConfig.getDigestAlgorithm()) != null) {
                wssSign.setDigestAlgo(digestAlgorithm.toString());
            }
            if (!(wsParts = this.createWSParts(signatureConfig)).isEmpty()) {
                wssSign.getParts().addAll(wsParts);
            }
            wssSign.build(this.getCrypto(keyStoreConfiguration));
        }
        catch (Exception e) {
            throw new WssSecurityException("Could not sign Envelope: " + e.getMessage(), e);
        }
    }

    private X509Certificate getSigningRequestCertificate(String correlationId, ObjectStoreManager runtimeObjectStoreManager) {
        ObjectStore defaultPartition = runtimeObjectStoreManager.getDefaultPartition();
        try {
            return (X509Certificate)defaultPartition.retrieve(correlationId);
        }
        catch (ObjectStoreException e) {
            return null;
        }
    }

    private List<WSEncryptionPart> createWSParts(BaseOutboundConfig baseOutboundConfig) {
        List<MessagePart> wssParts = baseOutboundConfig.getWssParts();
        if (wssParts == null) {
            return new ArrayList<WSEncryptionPart>();
        }
        return wssParts.stream().map(p -> new WSEncryptionPart(p.getLocalname(), p.getNamespace(), p.getEncode().toString())).collect(Collectors.toList());
    }

    private Crypto getCrypto(KeyStoreConfiguration keyStoreConfiguration) {
        try {
            return new Merlin(StoreConfigHandler.getWssProperties(keyStoreConfiguration), this.getClass().getClassLoader(), null);
        }
        catch (Exception e) {
            throw new WssException("Could not create crypto for keystore: " + keyStoreConfiguration.getPath(), e);
        }
    }

    public void handle(TimestampConfig timestampConfig) {
        WSSecTimestamp timestamp = new WSSecTimestamp(this.securityHeader);
        timestamp.setTimeToLive((int)TimeUnit.SECONDS.convert(timestampConfig.getTimeToLive().longValue(), timestampConfig.getTimeUnit()));
        timestamp.setPrecisionInMilliSeconds(timestamp.isPrecisionInMilliSeconds());
        timestamp.build();
    }
}

