/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.configuration.properties.internal;

import com.mulesoft.modules.configuration.properties.api.EncryptionAlgorithm;
import com.mulesoft.modules.configuration.properties.api.EncryptionMode;
import com.mulesoft.modules.configuration.properties.internal.NotSupportedInFipsModeException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.encryption.Encrypter;
import org.mule.encryption.exception.MuleEncryptionException;
import org.mule.encryption.exception.MuleInvalidAlgorithmConfigurationException;
import org.mule.runtime.core.api.util.Base64;

public class SecurePropertyPlaceholderModule {
    private static final String FIPS_SECURITY_MODEL = "fips140-2";
    private static final String PROPERTY_SECURITY_MODEL = "mule.security.model";
    private static final String FIPS_MODE_MESSAGE = "You're running in FIPS mode  so please verify that the algorithm is compliant with FIPS.";
    private Encrypter encrypter;
    private EncryptionAlgorithm encryptionAlgorithm;
    private EncryptionMode encryptionMode;
    private boolean useRandomIVs;

    public SecurePropertyPlaceholderModule(EncryptionAlgorithm algorithm, EncryptionMode mode, String key, boolean useRandomIVs) {
        this.encryptionAlgorithm = algorithm;
        this.encryptionMode = mode;
        this.useRandomIVs = useRandomIVs;
        this.buildEncrypter(key);
    }

    private void buildEncrypter(String key) {
        this.encrypter = this.encryptionAlgorithm.getBuilder().using(this.encryptionMode).forKey(this.readEnvironmentalProperties(key)).useRandomIVs(this.useRandomIVs).build();
    }

    private static boolean isFipsEnabled() {
        return FIPS_SECURITY_MODEL.equals(System.getProperty(PROPERTY_SECURITY_MODEL));
    }

    public byte[] decrypt(byte[] payload) throws MuleEncryptionException {
        try {
            return this.encrypter.decrypt(payload);
        }
        catch (MuleInvalidAlgorithmConfigurationException e) {
            if (SecurePropertyPlaceholderModule.isFipsEnabled()) {
                throw new MuleEncryptionException(e.getMessage(), (Exception)new NotSupportedInFipsModeException(FIPS_MODE_MESSAGE, (Exception)((Object)e)));
            }
            throw e;
        }
    }

    public void setKey(String key) {
        this.buildEncrypter(key);
    }

    public boolean isEncrypted(String value) {
        return value.startsWith("![") && value.endsWith("]");
    }

    public String convertPropertyValue(String originalValue) {
        if (!this.isEncrypted(originalValue)) {
            return originalValue;
        }
        String propertyKey = originalValue.substring(2, originalValue.length() - 1);
        try {
            return new String(this.decrypt(Base64.decode((String)propertyKey)));
        }
        catch (MuleEncryptionException e) {
            throw new RuntimeException(e);
        }
    }

    public String readEnvironmentalProperties(String text) {
        Pattern propertyPatter = Pattern.compile("\\$\\{([^}]+)}");
        Matcher propertyMatcher = propertyPatter.matcher(text);
        String modifiedText = text;
        while (propertyMatcher.find()) {
            String property = propertyMatcher.group(1);
            modifiedText = this.replaceProperty(modifiedText, property);
        }
        return modifiedText;
    }

    private String replaceProperty(String modifiedText, String property) {
        String propertyValue = System.getProperty(property);
        this.checkForPropertyExistence(property, propertyValue);
        propertyValue = this.convertPropertyValue(propertyValue);
        String pattern = "\\$\\{(" + property + ")}";
        Pattern replacement = Pattern.compile(pattern);
        Matcher replacementMatcher = replacement.matcher(modifiedText);
        replacementMatcher.find();
        return replacementMatcher.replaceAll(Matcher.quoteReplacement(propertyValue));
    }

    private void checkForPropertyExistence(String property, String propertyValue) {
        if (propertyValue == null) {
            throw new RuntimeException("Property " + property + " could not be found");
        }
    }
}

