/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.configuration.properties.internal;

import com.mulesoft.modules.configuration.properties.api.EncryptionAlgorithm;
import com.mulesoft.modules.configuration.properties.api.EncryptionMode;
import com.mulesoft.modules.configuration.properties.internal.SecurePropertyPlaceholderModule;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.encryption.exception.MuleEncryptionException;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.config.api.dsl.model.ResourceProvider;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationProperty;
import org.mule.runtime.config.api.dsl.model.properties.DefaultConfigurationPropertiesProvider;
import org.mule.runtime.core.api.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureConfigurationPropertiesProvider
extends DefaultConfigurationPropertiesProvider {
    private static final String SECURE_PREFIX = "secure::";
    private static final Pattern SECURE_PATTERN = Pattern.compile("\\$\\{secure::[^}]*}");
    private boolean logged_message = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(SecureConfigurationPropertiesProvider.class);
    private final EncryptionAlgorithm algorithm;
    private final EncryptionMode mode;
    private final boolean fileLevelEncryption;
    private final SecurePropertyPlaceholderModule securePropertyPlaceholderModule;

    public SecureConfigurationPropertiesProvider(ResourceProvider resourceProvider, String file, EncryptionAlgorithm algorithm, String key, EncryptionMode mode, String encoding, boolean fileLevelEncryption, boolean useRandomIVs) {
        super(file, encoding, resourceProvider);
        this.algorithm = algorithm;
        this.mode = mode;
        this.fileLevelEncryption = fileLevelEncryption;
        this.securePropertyPlaceholderModule = new SecurePropertyPlaceholderModule(algorithm, mode, key, useRandomIVs);
    }

    public Optional<ConfigurationProperty> getConfigurationProperty(String configurationAttributeKey) {
        if (!configurationAttributeKey.startsWith(SECURE_PREFIX)) {
            return Optional.empty();
        }
        String effectiveKey = configurationAttributeKey.substring(SECURE_PREFIX.length());
        final ConfigurationProperty originalConfigurationProperty = (ConfigurationProperty)this.configurationAttributes.get(effectiveKey);
        if (originalConfigurationProperty == null) {
            return Optional.empty();
        }
        String originalString = (String)originalConfigurationProperty.getRawValue();
        String encryptedValue = originalString.substring(originalConfigurationProperty.getKey().length() + 1, originalString.length() - this.algorithm.name().length() - this.mode.name().length() - 2);
        this.logWarningIfNotEncrypted(encryptedValue);
        final String decryptedValue = this.resolveInnerProperties(this.securePropertyPlaceholderModule.convertPropertyValue(encryptedValue));
        return Optional.of(new ConfigurationProperty(){

            public Object getSource() {
                return originalConfigurationProperty.getSource();
            }

            public Object getRawValue() {
                return decryptedValue;
            }

            public String getKey() {
                return originalConfigurationProperty.getKey();
            }
        });
    }

    public String getDescription() {
        ComponentLocation location = (ComponentLocation)this.getAnnotation(LOCATION_KEY);
        return String.format("<secure-properties file=\"%s\"> - file: %s, line number: %s", this.fileLocation, location.getFileName().orElse("unknown"), location.getLineInFile().map(String::valueOf).orElse("unknown"));
    }

    protected String createValue(String key, String value) {
        return String.format("%s:%s:%s:%s", new Object[]{key, value, this.algorithm, this.mode});
    }

    protected InputStream getResourceInputStream(String file) throws IOException {
        InputStream originalStream = super.getResourceInputStream(file);
        if (!this.fileLevelEncryption) {
            return originalStream;
        }
        byte[] content = IOUtils.toByteArray((InputStream)originalStream);
        try {
            return new ByteArrayInputStream(this.securePropertyPlaceholderModule.decrypt(Base64.getDecoder().decode(content)));
        }
        catch (MuleEncryptionException e) {
            throw new IOException(e);
        }
    }

    private String resolveInnerProperties(String decryptedValue) {
        Matcher m = SECURE_PATTERN.matcher(decryptedValue);
        while (m.find()) {
            String secureInnerProperty = m.group();
            Optional<ConfigurationProperty> innerProperty = this.getConfigurationProperty(secureInnerProperty);
            if (!innerProperty.isPresent()) continue;
            String innerPropertyValue = (String)innerProperty.get().getRawValue();
            decryptedValue = decryptedValue.replaceAll(secureInnerProperty, innerPropertyValue);
        }
        return decryptedValue;
    }

    private void logWarningIfNotEncrypted(String value) {
        boolean shouldLog;
        boolean bl = shouldLog = !this.logged_message && !this.fileLevelEncryption && !this.securePropertyPlaceholderModule.isEncrypted(value);
        if (shouldLog) {
            this.logged_message = true;
            LOGGER.warn(String.format("Secure Properties file has non-encrypted values. Check file '%s'. Remember to encrypt properties or use file-level encryption before going into productive environment", this.fileLocation));
        }
    }
}

