/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.configuration.properties.internal.keyfactories;

import java.security.Key;
import javax.crypto.spec.SecretKeySpec;
import org.mule.encryption.key.SymmetricKeyFactory;

public class SymmetricEncryptionKeyFactory
implements SymmetricKeyFactory {
    private String algorithm;
    private String key;

    public SymmetricEncryptionKeyFactory(String algorithm, String key) {
        this.algorithm = algorithm;
        this.key = key;
        this.validateKey();
    }

    public Key encryptionKey() {
        byte[] bytes = this.key.getBytes();
        return new SecretKeySpec(bytes, this.algorithm);
    }

    private void validateKey() {
        if (this.key == null) {
            throw new IllegalArgumentException("If keystore is not defined then the key is considered to be an encryption key in Base64 encoding");
        }
    }
}

