/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.configuration.properties.internal;

import com.mulesoft.modules.configuration.properties.api.EncryptionAlgorithm;
import com.mulesoft.modules.configuration.properties.api.EncryptionMode;
import com.mulesoft.modules.configuration.properties.internal.SecurePropertyPlaceholderModule;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.config.api.dsl.model.ResourceProvider;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationProperty;
import org.mule.runtime.config.api.dsl.model.properties.DefaultConfigurationPropertiesProvider;

public class SecureConfigurationPropertiesProvider
extends DefaultConfigurationPropertiesProvider {
    private static final String SECURE_PREFIX = "secure::";
    private static final Pattern SECURE_PATTERN = Pattern.compile("\\$\\{secure::[^\\}]*\\}");
    private final EncryptionAlgorithm algorithm;
    private final EncryptionMode mode;
    private SecurePropertyPlaceholderModule securePropertyPlaceholderModule = new SecurePropertyPlaceholderModule();

    public SecureConfigurationPropertiesProvider(ResourceProvider resourceProvider, String file, EncryptionAlgorithm algorithm, String key, EncryptionMode mode) {
        super(file, resourceProvider);
        this.algorithm = algorithm;
        this.mode = mode;
        this.securePropertyPlaceholderModule.setEncryptionMode(mode);
        this.securePropertyPlaceholderModule.setEncryptionAlgorithm(algorithm);
        this.securePropertyPlaceholderModule.setKey(key);
    }

    public Optional<ConfigurationProperty> getConfigurationProperty(String configurationAttributeKey) {
        if (configurationAttributeKey.startsWith(SECURE_PREFIX)) {
            String effectiveKey = configurationAttributeKey.substring(SECURE_PREFIX.length());
            final ConfigurationProperty originalConfigurationProperty = (ConfigurationProperty)this.configurationAttributes.get(effectiveKey);
            if (originalConfigurationProperty == null) {
                return Optional.empty();
            }
            String originalString = (String)originalConfigurationProperty.getRawValue();
            String encryptedValue = originalString.substring(originalConfigurationProperty.getKey().length() + 1, originalString.length() - this.algorithm.name().length() - this.mode.name().length() - 2);
            final String decryptedValue = this.resolveInnerProperties(this.securePropertyPlaceholderModule.convertPropertyValue(encryptedValue));
            return Optional.of(new ConfigurationProperty(){

                public Object getSource() {
                    return originalConfigurationProperty.getSource();
                }

                public Object getRawValue() {
                    return decryptedValue;
                }

                public String getKey() {
                    return originalConfigurationProperty.getKey();
                }
            });
        }
        return Optional.empty();
    }

    public String getDescription() {
        ComponentLocation location = (ComponentLocation)this.getAnnotation(LOCATION_KEY);
        return String.format("<secure-properties file=\"%s\"> - file: %s, line number: %s", this.fileLocation, location.getFileName().orElse("unknown"), location.getLineInFile().map(String::valueOf).orElse("unknown"));
    }

    protected String createValue(String key, String value) {
        return String.format("%s:%s:%s:%s", new Object[]{key, value, this.algorithm, this.mode});
    }

    private String resolveInnerProperties(String decryptedValue) {
        Matcher m = SECURE_PATTERN.matcher(decryptedValue);
        while (m.find()) {
            String secureInnerProperty = m.group();
            Optional<ConfigurationProperty> innerProperty = this.getConfigurationProperty(secureInnerProperty);
            if (!innerProperty.isPresent()) continue;
            String innerPropertyValue = (String)innerProperty.get().getRawValue();
            decryptedValue = decryptedValue.replaceAll(secureInnerProperty, innerPropertyValue);
        }
        return decryptedValue;
    }
}

