/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.configuration.properties.internal.jce.algorithms;

import com.mulesoft.modules.configuration.properties.internal.jce.algorithms.EncrypterBuilderFactory;
import com.mulesoft.modules.configuration.properties.internal.jce.factories.AsymmetricEncrypterBuilder;
import com.mulesoft.modules.configuration.properties.internal.jce.factories.EncrypterBuilder;
import com.mulesoft.modules.configuration.properties.internal.jce.factories.SymmetricEncrypterBuilder;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;

public enum EncryptionAlgorithm {
    AES(16, 16, algorithm -> new SymmetricEncrypterBuilder(algorithm)),
    Blowfish(0, 1, algorithm -> new SymmetricEncrypterBuilder(algorithm)),
    DES(0, 8, algorithm -> new SymmetricEncrypterBuilder(algorithm)),
    DESede(0, 16, algorithm -> new SymmetricEncrypterBuilder(algorithm)),
    Camellia(16, 16, algorithm -> new SymmetricEncrypterBuilder(algorithm)),
    CAST5(8, 1, algorithm -> new SymmetricEncrypterBuilder(algorithm)),
    CAST6(16, 1, algorithm -> new SymmetricEncrypterBuilder(algorithm)),
    Noekeon(16, 16, algorithm -> new SymmetricEncrypterBuilder(algorithm)),
    Rijndael(16, 16, algorithm -> new SymmetricEncrypterBuilder(algorithm)),
    SEED(16, 16, algorithm -> new SymmetricEncrypterBuilder(algorithm)),
    Serpent(16, 16, algorithm -> new SymmetricEncrypterBuilder(algorithm)),
    Skipjack(8, 16, algorithm -> new SymmetricEncrypterBuilder(algorithm)),
    TEA(0, 16, algorithm -> new SymmetricEncrypterBuilder(algorithm)),
    Twofish(16, 8, algorithm -> new SymmetricEncrypterBuilder(algorithm)),
    XTEA(8, 16, algorithm -> new SymmetricEncrypterBuilder(algorithm)),
    RC2(0, 1, algorithm -> new SymmetricEncrypterBuilder(algorithm)),
    RC5(0, 1, algorithm -> new SymmetricEncrypterBuilder(algorithm)),
    RC6(16, 1, algorithm -> new SymmetricEncrypterBuilder(algorithm)),
    RSA(0, 16, algorithm -> new AsymmetricEncrypterBuilder());

    private int minSize;
    private EncrypterBuilderFactory factory;
    private int ivSize;

    public int getMinKeySize() {
        return this.minSize;
    }

    private EncryptionAlgorithm(int ivSize, int minSize, EncrypterBuilderFactory factory) {
        this.minSize = minSize;
        this.factory = factory;
        this.ivSize = ivSize;
    }

    public EncrypterBuilder getBuilder() {
        return this.factory.createFor(this);
    }

    public int getIvSize() {
        return this.ivSize;
    }

    public int getMaxKeySize() {
        try {
            return Cipher.getMaxAllowedKeyLength(this.name()) / 8;
        }
        catch (NoSuchAlgorithmException e) {
            return 0;
        }
    }
}

