/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.configuration.properties.internal.jce;

import com.mulesoft.modules.configuration.properties.internal.MuleEncryptionException;
import com.mulesoft.modules.configuration.properties.internal.NotSupportedInFipsModeException;
import com.mulesoft.modules.configuration.properties.internal.jce.algorithms.EncryptionAlgorithm;
import com.mulesoft.modules.configuration.properties.internal.jce.algorithms.EncryptionMode;
import com.mulesoft.modules.configuration.properties.internal.jce.algorithms.EncryptionPadding;
import com.mulesoft.modules.configuration.properties.internal.keyfactories.AESFactory;
import com.mulesoft.modules.configuration.properties.internal.keyfactories.EncryptionKeyFactory;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;

public class JCEEncrypter {
    protected EncryptionAlgorithm encryptionAlgorithm;
    protected EncryptionMode encryptionMode;
    protected EncryptionPadding encryptionPadding;
    private EncryptionKeyFactory keyFactory;
    private static final String INSTALL_JCE_MESSAGE = "You need to install the Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files";
    private static final String FIPS_MODE_MESSAGE = "You're running in FIPS mode  so please verify that the algorithm is compliant with FIPS.";
    private static final String SHORT_KEY_MESSAGE = "You need to increment your key size  The minimum allowed key size is: %d  But your key size is: %d";
    private static final String LONG_KEY_MESSAGE = "Your key size exceeds the maximum allowed key size in your JVM.  The maximum allowed key size is: %d But your key size is: %d.";

    public JCEEncrypter(EncryptionAlgorithm encryptionAlgorithm, EncryptionMode encryptionMode, EncryptionPadding encryptionPadding, EncryptionKeyFactory keyFactory) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.encryptionMode = encryptionMode;
        this.encryptionPadding = encryptionPadding;
        this.keyFactory = keyFactory;
    }

    public byte[] decrypt(byte[] data) throws MuleEncryptionException {
        try {
            Cipher cipher = AESFactory.getCipher(this.createXForm());
            Key cipherKey = this.keyFactory.buildDecryptionKey();
            this.runCipher(cipher, cipherKey, 2, this.keyFactory.getPlainKey());
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw this.buildEncryptionException(e, this.keyFactory.getPlainKey());
        }
    }

    private String createXForm() {
        return this.encryptionAlgorithm.name() + "/" + this.encryptionMode.name() + "/" + this.encryptionPadding.name();
    }

    private void runCipher(Cipher cipher, Key cipherKey, int mode, String key) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.encryptionMode.equals((Object)EncryptionMode.ECB)) {
            cipher.init(mode, cipherKey);
        } else {
            IvParameterSpec ips = new IvParameterSpec(Arrays.copyOfRange(key.getBytes(), 0, this.ivSize()));
            cipher.init(mode, cipherKey, ips);
        }
    }

    private int ivSize() {
        return this.encryptionAlgorithm.getIvSize() == 0 ? 8 : this.encryptionAlgorithm.getIvSize();
    }

    private MuleEncryptionException buildEncryptionException(Exception e, String key) {
        if (e instanceof InvalidAlgorithmParameterException) {
            return this.handleInvalidAlgorithmParameterException((InvalidAlgorithmParameterException)e);
        }
        if (e instanceof InvalidKeyException) {
            return this.handleInvalidKeyException((InvalidKeyException)e, key);
        }
        if (e instanceof NoSuchAlgorithmException) {
            return this.wrapNoSuchAlgorithmException((NoSuchAlgorithmException)e);
        }
        return new MuleEncryptionException("Could not encrypt or decrypt the data.", e);
    }

    private MuleEncryptionException handleInvalidAlgorithmParameterException(InvalidAlgorithmParameterException e) {
        String message = String.format("Wrong configuration for algorithm: %s.", this.encryptionAlgorithm.name());
        if (!AESFactory.isJCEInstalled()) {
            message = message + INSTALL_JCE_MESSAGE;
        }
        return new MuleEncryptionException(message, e);
    }

    private MuleEncryptionException wrapNoSuchAlgorithmException(NoSuchAlgorithmException e) {
        String message = String.format("Invalid algorithm: %s.", this.encryptionAlgorithm.name());
        if (!AESFactory.isJCEInstalled()) {
            message = message + INSTALL_JCE_MESSAGE;
            return new MuleEncryptionException(message, e);
        }
        if (AESFactory.isFipsEnabled()) {
            return new MuleEncryptionException(message, new NotSupportedInFipsModeException(FIPS_MODE_MESSAGE, e));
        }
        return new MuleEncryptionException(message, e);
    }

    private MuleEncryptionException handleInvalidKeyException(InvalidKeyException e, String key) {
        String message = String.format("Invalid key: %s. ", key);
        if (key.getBytes().length > this.encryptionAlgorithm.getMaxKeySize()) {
            message = message + String.format(LONG_KEY_MESSAGE, this.encryptionAlgorithm.getMaxKeySize(), key.getBytes().length);
            if (!AESFactory.isJCEInstalled()) {
                message = message + INSTALL_JCE_MESSAGE;
            }
        } else if (key.getBytes().length < this.encryptionAlgorithm.getMinKeySize()) {
            message = message + String.format(SHORT_KEY_MESSAGE, this.encryptionAlgorithm.getMinKeySize(), key.getBytes().length);
        }
        return new MuleEncryptionException(message, e);
    }

    public byte[] encrypt(byte[] data) throws MuleEncryptionException {
        try {
            Cipher cipher = AESFactory.getCipher(this.createXForm());
            Key cipherKey = this.keyFactory.buildEncryptionKey();
            this.runCipher(cipher, cipherKey, 1, this.keyFactory.getPlainKey());
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw this.buildEncryptionException(e, this.keyFactory.getPlainKey());
        }
    }
}

