/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.configuration.properties.internal.extension;

import com.mulesoft.modules.configuration.properties.internal.SecurePropertyPlaceholderModule;
import java.util.Optional;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.config.api.dsl.model.ResourceProvider;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationProperty;
import org.mule.runtime.config.api.dsl.model.properties.DefaultConfigurationPropertiesProvider;

public class SecureConfigurationPropertiesProvider
extends DefaultConfigurationPropertiesProvider {
    private static final String SECURE_PREFIX = "secure::";
    private final String algorithm;
    private final String mode;
    private SecurePropertyPlaceholderModule securePropertyPlaceholderModule = new SecurePropertyPlaceholderModule();

    public SecureConfigurationPropertiesProvider(ResourceProvider resourceProvider, String file, String algorithm, String key, String mode) {
        super(file, resourceProvider);
        this.algorithm = algorithm;
        this.mode = mode;
        this.securePropertyPlaceholderModule.setEncryptionMode(mode);
        this.securePropertyPlaceholderModule.setEncryptionAlgorithm(algorithm);
        this.securePropertyPlaceholderModule.setKey(key);
    }

    public Optional<ConfigurationProperty> getConfigurationProperty(String configurationAttributeKey) {
        if (configurationAttributeKey.startsWith(SECURE_PREFIX)) {
            String effectiveKey = configurationAttributeKey.substring(SECURE_PREFIX.length());
            final ConfigurationProperty originalConfigurationProperty = (ConfigurationProperty)this.configurationAttributes.get(effectiveKey);
            if (originalConfigurationProperty == null) {
                return Optional.empty();
            }
            String encryptedValue = ((String)originalConfigurationProperty.getRawValue()).split(":")[1];
            final String decryptedValue = this.securePropertyPlaceholderModule.convertPropertyValue(encryptedValue);
            return Optional.of(new ConfigurationProperty(){

                public Object getSource() {
                    return originalConfigurationProperty.getSource();
                }

                public Object getRawValue() {
                    return decryptedValue;
                }

                public String getKey() {
                    return originalConfigurationProperty.getKey();
                }
            });
        }
        return Optional.empty();
    }

    public String getDescription() {
        ComponentLocation location = (ComponentLocation)this.getAnnotation(LOCATION_KEY);
        return String.format("<secure-properties file=\"%s\"> - file: %s, line number: %s", this.fileLocation, location.getFileName().orElse("unknown"), location.getLineInFile().map(String::valueOf).orElse("unknown"));
    }

    protected String createValue(String key, String value) {
        return String.format("%s:%s:%s:%s", key, value, this.algorithm, this.mode);
    }
}

