/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.configuration.properties.internal;

import com.mulesoft.modules.configuration.properties.internal.MuleEncryptionException;
import com.mulesoft.modules.configuration.properties.internal.jce.algorithms.EncryptionAlgorithm;
import com.mulesoft.modules.configuration.properties.internal.jce.algorithms.EncryptionMode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.runtime.core.api.util.Base64;

public class SecurePropertyPlaceholderModule {
    private EncryptionAlgorithm encryptionAlgorithm = EncryptionAlgorithm.AES;
    private EncryptionMode encryptionMode = EncryptionMode.CBC;
    private String key;

    public byte[] decrypt(byte[] payload) throws MuleEncryptionException {
        return this.encryptionAlgorithm.getBuilder().using(this.encryptionMode).forKey(this.key).build().decrypt(payload);
    }

    public String convertPropertyValue(String originalValue) {
        if (!originalValue.startsWith("![") || !originalValue.endsWith("]")) {
            return originalValue;
        }
        String propertyKey = originalValue.substring(2, originalValue.length() - 1);
        try {
            return new String(this.decrypt(Base64.decode((String)propertyKey)));
        }
        catch (MuleEncryptionException e) {
            throw new RuntimeException(e);
        }
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(String encryptionAlgorithm) {
        this.setEncryptionAlgorithm(EncryptionAlgorithm.valueOf(encryptionAlgorithm));
    }

    public EncryptionMode getEncryptionMode() {
        return this.encryptionMode;
    }

    public void setEncryptionMode(EncryptionMode encryptionMode) {
        this.encryptionMode = encryptionMode;
    }

    public void setEncryptionMode(String encryptionMode) {
        this.setEncryptionMode(EncryptionMode.valueOf(encryptionMode));
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = this.readEnvironmentalProperties(key);
    }

    public String readEnvironmentalProperties(String text) {
        Pattern propertyPatter = Pattern.compile("\\$\\{([^\\}]+)\\}");
        Matcher propertyMatcher = propertyPatter.matcher(text);
        String modifiedText = text;
        while (propertyMatcher.find()) {
            String property = propertyMatcher.group(1);
            modifiedText = this.replaceProperty(modifiedText, property);
        }
        return modifiedText;
    }

    private String replaceProperty(String modifiedText, String property) {
        String propertyValue = System.getProperty(property);
        this.checkForPropertyExistence(property, propertyValue);
        propertyValue = this.convertPropertyValue(propertyValue);
        String pattern = "\\$\\{(" + property + ")\\}";
        Pattern replacement = Pattern.compile(pattern);
        Matcher replacementMatcher = replacement.matcher(modifiedText);
        replacementMatcher.find();
        return replacementMatcher.replaceAll(Matcher.quoteReplacement(propertyValue));
    }

    private void checkForPropertyExistence(String property, String propertyValue) {
        if (propertyValue == null) {
            throw new RuntimeException("Property " + property + " could not be found");
        }
    }
}

