/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.internal.token;

import com.mulesoft.modules.oauth2.provider.api.token.AccessTokenStoreHolder;
import com.mulesoft.modules.oauth2.provider.api.token.Token;
import com.mulesoft.modules.oauth2.provider.internal.OAuth2ProviderSecurityException;
import com.mulesoft.modules.oauth2.provider.internal.token.ForbiddenSecurityException;
import com.mulesoft.modules.oauth2.provider.internal.token.TokenAuthentication;
import com.mulesoft.modules.oauth2.provider.internal.token.TokenManager;
import com.mulesoft.modules.oauth2.provider.internal.token.UnauthorizedSecurityException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.core.api.security.AbstractSecurityProvider;

public class TokenSecurityProvider
extends AbstractSecurityProvider {
    public static final String NAME = "tokenSecurityProvider";
    private TokenManager tokenManager;

    public TokenSecurityProvider(String namePrefix, TokenManager tokenManager) {
        super(namePrefix + "." + NAME);
        this.tokenManager = tokenManager;
    }

    public boolean supports(Class<?> aClass) {
        return TokenAuthentication.class.isAssignableFrom(aClass);
    }

    public Authentication authenticate(Authentication authentication) throws SecurityException {
        HashSet<String> savedScopesSet;
        Set<String> scopesToValidate;
        if (!this.supports(authentication.getClass())) {
            throw new OAuth2ProviderSecurityException("Provider can't authenticate token class");
        }
        TokenAuthentication tokenAuthentication = (TokenAuthentication)authentication;
        String accessTokenToValidate = tokenAuthentication.getToken();
        AccessTokenStoreHolder storedTokenHolder = this.tokenManager.getNonExpiredAccessTokenHolder(accessTokenToValidate);
        if (storedTokenHolder == null) {
            throw new UnauthorizedSecurityException(String.format("The token received: %s , is not valid", accessTokenToValidate));
        }
        Set<String> resourceOwnerRoles = tokenAuthentication.getResourceOwnerRoles();
        if (CollectionUtils.isNotEmpty(resourceOwnerRoles)) {
            Set savedResourceOwnerRoles;
            Set<Object> set = savedResourceOwnerRoles = storedTokenHolder.getResourceOwnerAuthentication() == null ? Collections.emptySet() : storedTokenHolder.getResourceOwnerAuthentication().getRoles();
            if (CollectionUtils.isEmpty((Collection)CollectionUtils.intersection(resourceOwnerRoles, savedResourceOwnerRoles))) {
                throw new UnauthorizedSecurityException("Resource owner roles do not match");
            }
        }
        if (CollectionUtils.isNotEmpty(scopesToValidate = tokenAuthentication.getScopes()) && CollectionUtils.isEmpty((Collection)CollectionUtils.intersection(scopesToValidate, savedScopesSet = new HashSet<String>(storedTokenHolder.getAccessToken().getScopes())))) {
            throw new ForbiddenSecurityException("Scopes do not match");
        }
        Token savedToken = storedTokenHolder.getAccessToken();
        if (!accessTokenToValidate.equals(savedToken.getAccessToken())) {
            throw new UnauthorizedSecurityException("Tokens do not match");
        }
        return TokenAuthentication.builder(tokenAuthentication).withTokenHolder(storedTokenHolder).build();
    }
}

