/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.internal.processor;

import com.mulesoft.modules.oauth2.provider.internal.OAuth2ProviderSecurityException;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.Preconditions;

public class RequestProcessingException
extends OAuth2ProviderSecurityException {
    private static final long serialVersionUID = 7580399665743587412L;
    private final ErrorType errorType;

    public RequestProcessingException(ErrorType errorType) {
        this(errorType, null, null);
    }

    public RequestProcessingException(ErrorType errorType, String errorDescription) {
        this(errorType, errorDescription, null);
    }

    public RequestProcessingException(ErrorType errorType, Throwable cause) {
        this(errorType, null, cause);
    }

    public RequestProcessingException(ErrorType errorType, String errorDescription, Throwable cause) {
        super(StringUtils.trimToEmpty((String)errorDescription), cause);
        this.errorType = errorType;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public static enum ErrorType {
        INVALID_REDIRECTION_URI(false, "redirect_uri"),
        INVALID_CLIENT_ID("client_id"),
        INVALID_CLIENT,
        INVALID_GRANT,
        INVALID_REQUEST,
        UNAUTHORIZED_CLIENT,
        ACCESS_DENIED,
        UNSUPPORTED_RESPONSE_TYPE("response_type"),
        UNSUPPORTED_GRANT_TYPE,
        INVALID_SCOPE,
        TEMPORARILY_UNAVAILABLE,
        SERVER_ERROR,
        RATE_LIMIT_EXCEEDED(false);

        private final boolean doRedirect;
        private final String relatedParameter;

        private ErrorType() {
            this(true);
        }

        private ErrorType(boolean doRedirect) {
            this(doRedirect, null);
        }

        private ErrorType(String relatedParameter) {
            this(true, relatedParameter);
        }

        private ErrorType(boolean doRedirect, String relatedParameter) {
            this.doRedirect = doRedirect;
            this.relatedParameter = relatedParameter;
        }

        public String getErrorCode() {
            return this.toString().toLowerCase();
        }

        public boolean isDoRedirect() {
            return this.doRedirect;
        }

        public static ErrorType findByParameterName(String parameterName) {
            Preconditions.checkArgument((parameterName != null ? 1 : 0) != 0, (String)"parameterName can't be empty");
            for (ErrorType et : ErrorType.values()) {
                if (!parameterName.equals(et.relatedParameter)) continue;
                return et;
            }
            return null;
        }
    }
}

