/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.api.client;

import com.mulesoft.modules.oauth2.provider.api.client.Client;
import com.mulesoft.modules.oauth2.provider.api.client.ClientAlreadyExistsException;
import com.mulesoft.modules.oauth2.provider.api.client.ClientStore;
import com.mulesoft.modules.oauth2.provider.api.client.KeyFormatter;
import com.mulesoft.modules.oauth2.provider.api.client.NoSuchClientException;
import com.mulesoft.modules.oauth2.provider.internal.AbstractObjectStoreBacked;
import com.mulesoft.modules.oauth2.provider.internal.client.ClientRegistration;
import com.mulesoft.modules.oauth2.provider.internal.client.DefaultKeyFormatter;
import org.mule.runtime.api.store.ObjectAlreadyExistsException;
import org.mule.runtime.api.store.ObjectStore;

public class ObjectStoreClientStore
extends AbstractObjectStoreBacked<Client>
implements ClientStore,
ClientRegistration {
    public static final String CLIENTS_PARTITION = "Clients";
    private KeyFormatter formatter = new DefaultKeyFormatter();
    private ObjectStore clientObjectStore;

    @Override
    public Client getClientById(String clientId) throws NoSuchClientException {
        return this.getClientById(clientId, "");
    }

    @Override
    public Client getClientById(String clientId, String clientSecret) throws NoSuchClientException {
        Client client = (Client)this.getFromObjectStore(this.key(clientId, clientSecret), this.clientObjectStore);
        if (client == null) {
            throw new NoSuchClientException("Client Id is invalid");
        }
        return client;
    }

    @Override
    public void addClient(Client client, boolean failIfPresent) throws ClientAlreadyExistsException {
        try {
            this.putInObjectStore(this.key(client), client, this.clientObjectStore, failIfPresent);
        }
        catch (ObjectAlreadyExistsException e) {
            throw new ClientAlreadyExistsException(String.format("The client with ID: %s is already registered", client.getClientId()));
        }
    }

    @Override
    public void removeClient(String clientId) {
        this.removeClient(clientId, "");
    }

    @Override
    public void removeClient(String clientId, String clientSecret) throws NoSuchClientException {
        Client client = (Client)this.removeFromObjectStore(this.key(clientId, clientSecret), this.clientObjectStore);
        if (client == null) {
            throw new NoSuchClientException(String.format("Client with ID %s does not exist", clientId));
        }
    }

    public void setObjectStore(ObjectStore clientObjectStore) {
        this.clientObjectStore = clientObjectStore;
    }

    public void setKeyFormatter(KeyFormatter formatter) {
        this.formatter = formatter;
    }

    public ObjectStore getClientObjectStore() {
        return this.clientObjectStore;
    }

    private String key(String clientId, String clientSecret) {
        return this.formatter.format(clientId, clientSecret);
    }

    private String key(Client client) {
        return this.key(client.getClientId(), client.getSecret());
    }
}

