/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.api.client;

import com.mulesoft.modules.oauth2.provider.api.Constants;
import com.mulesoft.modules.oauth2.provider.api.client.ClientType;
import com.mulesoft.modules.oauth2.provider.internal.processor.ClientSecretCredentials;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;

public final class Client
implements Serializable,
Component {
    private static final long serialVersionUID = -4691673785889272016L;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    private String clientId;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.SUPPORTED)
    private String principal;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.SUPPORTED)
    private String clientName;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.SUPPORTED)
    private String description;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.SUPPORTED)
    private String secret;
    @Parameter
    @Optional
    @NullSafe
    @Expression(value=ExpressionSupport.SUPPORTED)
    private Set<String> clientRedirectUris;
    @Parameter
    @Optional
    @NullSafe
    @Expression(value=ExpressionSupport.SUPPORTED)
    private Set<Constants.RequestGrantType> clientAuthorizedGrantTypes;
    @Parameter
    @Optional
    @NullSafe
    @Expression(value=ExpressionSupport.SUPPORTED)
    private Set<String> clientScopes;
    @Parameter
    @Optional(defaultValue="PUBLIC")
    private ClientType type;
    private transient ConcurrentMap<String, Pattern> redirectUriPatternCache;

    public void setAnnotations(Map<QName, Object> annotations) {
    }

    public Location getRootContainerLocation() {
        return null;
    }

    public Object getAnnotation(QName name) {
        return null;
    }

    public Map<QName, Object> getAnnotations() {
        return null;
    }

    public ComponentLocation getLocation() {
        return null;
    }

    public Client() {
        this.redirectUriPatternCache = new ConcurrentHashMap<String, Pattern>();
    }

    public Client(String clientId, String secret, ClientType type, Set<String> clientRedirectUris, Set<Constants.RequestGrantType> clientAuthorizedGrantTypes, Set<String> clientScopes) {
        Preconditions.checkArgument((!org.mule.runtime.core.api.util.StringUtils.isEmpty((String)clientId) ? 1 : 0) != 0, (String)"id can't be empty");
        this.clientId = clientId;
        this.secret = secret;
        this.type = type;
        this.clientRedirectUris = clientRedirectUris == null ? new HashSet() : clientRedirectUris;
        this.clientAuthorizedGrantTypes = clientAuthorizedGrantTypes == null ? new HashSet() : clientAuthorizedGrantTypes;
        this.clientScopes = clientScopes == null ? new HashSet() : clientScopes;
        this.redirectUriPatternCache = new ConcurrentHashMap<String, Pattern>();
    }

    public boolean isAuthenticatedBy(ClientSecretCredentials clientSecretCredentials) {
        return StringUtils.isNotBlank((CharSequence)this.getSecret()) && StringUtils.equals((CharSequence)this.getSecret(), (CharSequence)clientSecretCredentials.getClientSecret());
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public Set<String> getRedirectUris() {
        return this.clientRedirectUris;
    }

    public void setRedirectUris(Set<String> redirectUris) {
        this.clientRedirectUris.addAll(redirectUris);
    }

    public Set<Constants.RequestGrantType> getAuthorizedGrantTypes() {
        return this.clientAuthorizedGrantTypes;
    }

    public void setAuthorizedGrantTypes(Set<Constants.RequestGrantType> authorizedGrantTypes) {
        this.clientAuthorizedGrantTypes.addAll(authorizedGrantTypes);
    }

    public ClientType getType() {
        return this.type;
    }

    public void setType(ClientType type) {
        this.type = type;
    }

    public Set<String> getScopes() {
        return this.clientScopes;
    }

    public void setScopes(Set<String> scopes) {
        this.clientScopes.addAll(scopes);
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public ConcurrentMap<String, Pattern> getRedirectUriPatternCache() {
        return this.redirectUriPatternCache;
    }

    public void setRedirectUriPatternCache(ConcurrentMap<String, Pattern> redirectUriPatternCache) {
        this.redirectUriPatternCache = redirectUriPatternCache;
    }

    public boolean isValidRedirectUri(String testedRedirectUri) {
        if (StringUtils.isBlank((CharSequence)testedRedirectUri)) {
            return false;
        }
        if (this.clientRedirectUris == null || this.clientRedirectUris.isEmpty()) {
            return false;
        }
        for (String redirectUri : this.clientRedirectUris) {
            Pattern pattern = null;
            if (this.redirectUriPatternCache != null) {
                this.redirectUriPatternCache.get(redirectUri);
            }
            if (pattern == null) {
                String redirectUriRegex = StringUtils.replace((String)Pattern.quote(redirectUri), (String)"*", (String)"\\E.*\\Q");
                pattern = Pattern.compile(redirectUriRegex);
                this.redirectUriPatternCache.put(redirectUri, pattern);
            }
            if (!pattern.matcher(testedRedirectUri).matches()) continue;
            return true;
        }
        return false;
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.redirectUriPatternCache = new ConcurrentHashMap<String, Pattern>();
    }

    public boolean isGrantTypeAuthorized(Constants.RequestGrantType grantType) {
        return this.clientAuthorizedGrantTypes != null && this.clientAuthorizedGrantTypes.contains((Object)grantType);
    }
}

