/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.internal.velocity;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.util.ExtProperties;

public class FileResourceLoader
extends ResourceLoader {
    public void init(ExtProperties configuration) {
    }

    public Reader getResourceReader(String source, String encoding) throws ResourceNotFoundException {
        Object reader = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(source);
            return this.buildReader(inputStream, encoding);
        }
        catch (IOException io) {
            this.close(inputStream);
            throw new ResourceNotFoundException((Throwable)io);
        }
    }

    private void close(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean resourceExists(String resourceName) {
        return new File(resourceName).isFile();
    }

    public boolean isSourceModified(Resource resource) {
        return resource.getLastModified() != this.getLastModified(resource);
    }

    public long getLastModified(Resource resource) {
        File file = new File(resource.getName());
        if (file.isFile() && file.canRead()) {
            return file.lastModified();
        }
        return 0L;
    }
}

