/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.internal.code;

import com.mulesoft.modules.oauth2.provider.api.AuthorizationRequest;
import com.mulesoft.modules.oauth2.provider.api.code.AuthorizationCodeStore;
import com.mulesoft.modules.oauth2.provider.api.code.AuthorizationCodeStoreHolder;
import com.mulesoft.modules.oauth2.provider.api.exception.OAuth2Exception;
import com.mulesoft.modules.oauth2.provider.internal.Utils;
import com.mulesoft.modules.oauth2.provider.internal.token.InvalidGrantException;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.Preconditions;

public class AuthorizationCodeManager {
    private final AuthorizationCodeStore authorizationCodeStore;

    public AuthorizationCodeManager(AuthorizationCodeStore authorizationCodeStore) {
        Preconditions.checkArgument((authorizationCodeStore != null ? 1 : 0) != 0, (String)"authorizationCodeStore can't be null");
        this.authorizationCodeStore = authorizationCodeStore;
    }

    public String generateAuthorizationCode(AuthorizationRequest authorizationRequest) throws OAuth2Exception {
        String authorizationCode = Utils.generateUniqueId(authorizationRequest.getClientId());
        this.authorizationCodeStore.store(new AuthorizationCodeStoreHolder(authorizationCode, authorizationRequest));
        return authorizationCode;
    }

    public AuthorizationCodeStoreHolder consumeAuthorizationCode(String code) throws InvalidGrantException {
        AuthorizationCodeStoreHolder holder;
        AuthorizationCodeStoreHolder authorizationCodeStoreHolder = holder = StringUtils.isNotBlank((CharSequence)code) ? this.authorizationCodeStore.retrieve(code) : null;
        if (holder == null) {
            throw new InvalidGrantException("Authorization code is invalid or expired");
        }
        this.authorizationCodeStore.remove(code);
        return holder;
    }
}

