/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.internal;

import com.mulesoft.modules.oauth2.provider.api.Constants;
import com.mulesoft.modules.oauth2.provider.internal.processor.RequestData;
import com.mulesoft.modules.oauth2.provider.internal.processor.RequestProcessingException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.Base64;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);
    private static final Charset DEFAULT_HTTP_ENCODING = Charset.forName("ISO-8859-1");
    private static final boolean strictContentType = Boolean.getBoolean("mule.strictContentType");

    private Utils() {
        throw new UnsupportedOperationException("do not instantiate");
    }

    private static byte[] encodeBase64URLSafe(byte[] binaryData) {
        try {
            return StringUtils.stripEnd((String)StringUtils.replaceChars((String)Base64.encodeBytes((byte[])binaryData, (int)8), (String)"+/", (String)"-_"), (String)"=").getBytes();
        }
        catch (IOException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not encode to Base64"), (Throwable)e);
        }
    }

    public static String generateUniqueId(String salt) {
        byte[] hashedBytes;
        Preconditions.checkArgument((!org.mule.runtime.core.api.util.StringUtils.isEmpty((String)salt) ? 1 : 0) != 0, (String)"salt can't be empty");
        byte[] saltyBytes = salt.getBytes();
        UUID uuid = UUID.randomUUID();
        ByteBuffer byteBuffer = ByteBuffer.allocate(saltyBytes.length + 16).put(saltyBytes).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits());
        try {
            MessageDigest sha512Hash = MessageDigest.getInstance("SHA-512");
            hashedBytes = sha512Hash.digest(byteBuffer.array());
        }
        catch (NoSuchAlgorithmException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not generate unique Id"), (Throwable)e);
        }
        return new String(Utils.encodeBase64URLSafe(hashedBytes));
    }

    public static String generateUniqueId() {
        return Utils.generateUniqueId(Long.toString(Utils.class.hashCode()));
    }

    public static String extractCredentialsFromAuthorizationHeader(String authorization, String scheme, String encoding) {
        boolean validHeader;
        String[] tokens = org.mule.runtime.core.api.util.StringUtils.splitAndTrim((String)authorization, (String)" ");
        boolean bl = validHeader = tokens != null && tokens.length == 2 && StringUtils.equals((CharSequence)tokens[0], (CharSequence)scheme);
        if (!validHeader) {
            return null;
        }
        String token = tokens[1];
        if ("Bearer".equals(scheme)) {
            return token;
        }
        if ("Basic".equals(scheme)) {
            return Utils.newString(Base64.decode((String)token), encoding);
        }
        LOGGER.warn("Unsupported authorization scheme: " + scheme);
        return null;
    }

    private static String newString(byte[] bytes, String encoding) {
        try {
            return new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new MuleRuntimeException((Throwable)uee);
        }
    }

    public static Set<String> tokenize(String scope) {
        return Utils.tokenize(scope, " ");
    }

    public static Set<String> tokenize(String scope, String delimiter) {
        String[] tokens = org.mule.runtime.core.api.util.StringUtils.splitAndTrim((String)scope, (String)delimiter);
        return tokens == null ? new HashSet<String>() : new HashSet<String>(Arrays.asList(tokens));
    }

    public static String stringifyScopes(Set<String> scopes) {
        return StringUtils.trimToEmpty((String)StringUtils.join(scopes, (char)' '));
    }

    public static Set<String> computeEffectiveScopeOrFail(Set<String> requestedScopes, Set<String> clientScopes, Set<String> configuredScopes) throws RequestProcessingException {
        Collection supportedScopes = CollectionUtils.intersection(configuredScopes, clientScopes);
        if (CollectionUtils.isEmpty((Collection)supportedScopes) && !CollectionUtils.isEmpty(configuredScopes)) {
            LOGGER.warn("Client configured with scopes: " + clientScopes + " doesn't match any provider-configured scopes: " + configuredScopes);
            throw new RequestProcessingException(RequestProcessingException.ErrorType.TEMPORARILY_UNAVAILABLE, "Client configuration error");
        }
        if (CollectionUtils.isEmpty(requestedScopes) && CollectionUtils.isNotEmpty((Collection)supportedScopes)) {
            throw new RequestProcessingException(RequestProcessingException.ErrorType.INVALID_REQUEST, "Missing mandatory parameter: scope");
        }
        if (CollectionUtils.isEmpty(requestedScopes)) {
            return Collections.emptySet();
        }
        if (CollectionUtils.isSubCollection(requestedScopes, (Collection)supportedScopes)) {
            return requestedScopes;
        }
        throw new RequestProcessingException(RequestProcessingException.ErrorType.INVALID_SCOPE);
    }

    public static String urlDecode(String encoded) {
        if (encoded == null) {
            return null;
        }
        try {
            return URLDecoder.decode(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new MuleRuntimeException((Throwable)uee);
        }
    }

    public static Set<Constants.ProviderGrantType> parseProviderGrantTypes(String providerGrantTypes) {
        HashSet<Constants.ProviderGrantType> result = new HashSet<Constants.ProviderGrantType>();
        Set<String> tokens = Utils.tokenize(providerGrantTypes, ",");
        if (tokens != null) {
            for (String token : tokens) {
                result.add(Constants.ProviderGrantType.valueOf(token));
            }
        }
        return result;
    }

    public static Charset resolveMessageEncoding(RequestData requestData) {
        String contentTypeValue = requestData == null ? null : requestData.getContext().getRequest().getHeaderValueIgnoreCase("Content-Type");
        MediaType mediaType = Utils.getMediaType(contentTypeValue, DEFAULT_HTTP_ENCODING);
        return (Charset)mediaType.getCharset().get();
    }

    private static MediaType getMediaType(String contentTypeValue, Charset defaultCharset) {
        MediaType mediaType = MediaType.ANY;
        if (contentTypeValue != null) {
            try {
                mediaType = MediaType.parse((String)contentTypeValue);
            }
            catch (IllegalArgumentException e) {
                if (strictContentType) {
                    throw e;
                }
                LOGGER.warn(String.format("%s when parsing Content-Type '%s': %s", e.getClass().getName(), contentTypeValue, e.getMessage()));
                LOGGER.warn(String.format("Using default encoding: %s", Charset.defaultCharset().name()));
            }
        }
        if (!mediaType.getCharset().isPresent()) {
            return mediaType.withCharset(defaultCharset);
        }
        return mediaType;
    }

    public static ResponseStatusCallback getResponseStatusCallback() {
        return new ResponseStatusCallback(){

            public void responseSendFailure(Throwable throwable) {
                Utils.logFailureWhenSendingResponse(throwable);
            }

            public void responseSendSuccessfully() {
            }
        };
    }

    private static void logFailureWhenSendingResponse(Throwable throwable) {
        LOGGER.warn("Failure sending oauth2 provider static content response: " + throwable.getMessage());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(throwable.getMessage(), throwable);
        }
    }
}

