/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.xml.impl;

import com.mulesoft.modules.cryptography.internal.xml.XMLUtils;
import java.util.function.Predicate;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.Pair;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SignatureFilterSelector {
    private static final String DSIG_OBJECT_ELEMENT = "dsig:Object";

    public static Predicate<Pair<DOMValidateContext, XMLSignature>> forDocumentAndElementPath(Document document, String elementPath) {
        String uriToMatch;
        if (StringUtils.isBlank((CharSequence)elementPath)) {
            return signature -> true;
        }
        Element target = XMLUtils.validateXpathInDocument(document, elementPath);
        Node targetParent = target.getParentNode();
        if (targetParent.getNodeName().equals(DSIG_OBJECT_ELEMENT) && targetParent.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) {
            Element envelopingSignature = (Element)targetParent.getParentNode();
            return signature -> ((DOMValidateContext)signature.getFirst()).getNode().isEqualNode(envelopingSignature);
        }
        if (target.isSameNode(document.getDocumentElement())) {
            uriToMatch = "";
        } else {
            String idAttrName = XMLUtils.getIDAttributeName(target);
            target.setIdAttribute(idAttrName, true);
            uriToMatch = "#" + target.getAttribute(idAttrName);
        }
        return signature -> ((XMLSignature)signature.getSecond()).getSignedInfo().getReferences().get(0).getURI().equals(uriToMatch);
    }
}

