/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.xml.config;

import com.mulesoft.modules.cryptography.api.xml.config.XmlEncryptionAlgorithm;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import java.util.EnumMap;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlEncryptionAlgorithmResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlEncryptionAlgorithmResolver.class);
    private static final EnumMap<XmlEncryptionAlgorithm, AlgorithmInfo> ALGORITHM_INFO = new EnumMap(XmlEncryptionAlgorithm.class);

    public static String getAlgorithmUri(XmlEncryptionAlgorithm algorithm, int keySizeInBytes) {
        return ALGORITHM_INFO.get((Object)algorithm).getAlgorithmUri(keySizeInBytes);
    }

    public static String getKeyWrapUri(XmlEncryptionAlgorithm algorithm, int keySizeInBytes) {
        return ALGORITHM_INFO.get((Object)algorithm).getKeyWrapUri(keySizeInBytes);
    }

    public static int getDefaultKeySize(XmlEncryptionAlgorithm algorithm) {
        return ALGORITHM_INFO.get((Object)algorithm).getDefaultKeySizeInBytes();
    }

    static {
        ALGORITHM_INFO.put(XmlEncryptionAlgorithm.AES_CBC, new AesAlgorithmInfo(false));
        ALGORITHM_INFO.put(XmlEncryptionAlgorithm.AES_GCM, new AesAlgorithmInfo(true));
        ALGORITHM_INFO.put(XmlEncryptionAlgorithm.TRIPLEDES, new TripleDesAlgorithmInfo());
    }

    private static class TripleDesAlgorithmInfo
    implements AlgorithmInfo {
        private static final int VALID_KEY_SIZE = 21;

        private TripleDesAlgorithmInfo() {
        }

        @Override
        public String getAlgorithmUri(int keySizeInBytes) {
            this.validateKeySize(keySizeInBytes);
            return "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
        }

        @Override
        public String getKeyWrapUri(int keySizeInBytes) {
            this.validateKeySize(keySizeInBytes);
            return "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
        }

        @Override
        public int getDefaultKeySizeInBytes() {
            return 21;
        }

        @Override
        public void validateKeySize(int keySizeInBytes) {
            if (keySizeInBytes != 21) {
                String message = "TripleDES requires a key size of 168 bits";
                if (Boolean.getBoolean("com.mulesoft.crypto.allow.non.standard.key.size")) {
                    LOGGER.warn("WARNING: " + message + " but continuing due to " + "com.mulesoft.crypto.allow.non.standard.key.size" + " being enabled");
                } else {
                    throw new ModuleException(I18nMessageFactory.createStaticMessage((String)message), (ErrorTypeDefinition)CryptoErrors.KEY);
                }
            }
        }
    }

    private static class AesAlgorithmInfo
    implements AlgorithmInfo {
        private final boolean isGCM;
        private static final int[] VALID_KEY_SIZES = new int[]{16, 24, 32};

        public AesAlgorithmInfo(boolean isGCM) {
            this.isGCM = isGCM;
        }

        @Override
        public String getAlgorithmUri(int keySizeInBytes) {
            this.validateKeySize(keySizeInBytes);
            int keySizeInBits = keySizeInBytes * 8;
            if (keySizeInBits == 128) {
                return this.isGCM ? "http://www.w3.org/2009/xmlenc11#aes128-gcm" : "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
            }
            if (keySizeInBits == 192) {
                return this.isGCM ? "http://www.w3.org/2009/xmlenc11#aes192-gcm" : "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
            }
            if (keySizeInBits == 256) {
                return this.isGCM ? "http://www.w3.org/2009/xmlenc11#aes256-gcm" : "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
            }
            throw new IllegalStateException("Validaci\u00c3\u00b3n fallida");
        }

        @Override
        public String getKeyWrapUri(int keySizeInBytes) {
            this.validateKeySize(keySizeInBytes);
            int keySizeInBits = keySizeInBytes * 8;
            if (keySizeInBits == 128) {
                return "http://www.w3.org/2001/04/xmlenc#kw-aes128";
            }
            if (keySizeInBits == 192) {
                return "http://www.w3.org/2001/04/xmlenc#kw-aes192";
            }
            if (keySizeInBits == 256) {
                return "http://www.w3.org/2001/04/xmlenc#kw-aes256";
            }
            throw new IllegalStateException("Validaci\u00c3\u00b3n fallida");
        }

        @Override
        public int getDefaultKeySizeInBytes() {
            return 32;
        }

        @Override
        public void validateKeySize(int keySizeInBytes) {
            boolean isValid = false;
            for (int validSize : VALID_KEY_SIZES) {
                if (keySizeInBytes != validSize) continue;
                isValid = true;
                break;
            }
            if (!isValid) {
                throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"AES is only supported for keys of 128, 192 and 256 bits"), (ErrorTypeDefinition)CryptoErrors.KEY);
            }
        }
    }

    public static interface AlgorithmInfo {
        public String getAlgorithmUri(int var1);

        public String getKeyWrapUri(int var1);

        public int getDefaultKeySizeInBytes();

        public void validateKeySize(int var1);
    }
}

