/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.xml;

import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import com.mulesoft.modules.cryptography.internal.xml.NodeListUtils;
import com.mulesoft.modules.cryptography.internal.xml.SingleNodeSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.xmlsecurity.XMLSecureFactories;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtils {
    public static final String NOT_FOUND_ELEMENT_WITH_GIVEN_VALIDATION_EXPRESSION = "No element was found with the given elementPath. If your expression is right, this could be a (failed) attempt at xml signature wrapping attack.";
    public static final String MORE_THAN_ONE_ELEMENT_FOUND_WITH_GIVEN_VALIDATION_EXPRESSION = "More than one element were found with the given elementPath but only one is allowed";
    public static final String MORE_THAN_ONE_SIGNATURE_FOUND = "More than one signature was found in the xml source. Try to target the desired one with the elementPath attribute.";
    private static final String ID = "id";
    private static final NamespaceContext NAMESPACE_CONTEXT = new NamespaceContext(){

        @Override
        public String getNamespaceURI(String prefix) {
            return prefix.equalsIgnoreCase("dsig") ? "http://www.w3.org/2000/09/xmldsig#" : null;
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return namespaceURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#") ? "dsig" : null;
        }

        public Iterator getPrefixes(String namespaceURI) {
            return namespaceURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#") ? Arrays.asList("dsig").iterator() : Collections.emptyList().iterator();
        }
    };

    public static byte[] createXmlUsing(Document doc) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(bos);
            TransformerFactory transformerFactory = XMLSecureFactories.createDefault().getTransformerFactory();
            Transformer trans = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            trans.setOutputProperty("indent", "no");
            trans.transform(source, result);
            return bos.toByteArray();
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not build signed org.mule.security.encryption.xml"), (Throwable)e);
        }
    }

    public static Document documentBasedOnThe(byte[] xml) {
        try {
            DocumentBuilderFactory factory = XMLSecureFactories.createDefault().getDocumentBuilderFactory();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(xml));
            document.normalize();
            return document;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not create signed Document"), (Throwable)e);
        }
    }

    public static NodeList getElements(String xpathExpr, Document document) {
        try {
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            xpath.setNamespaceContext(NAMESPACE_CONTEXT);
            if (!StringUtils.isBlank((String)xpathExpr)) {
                XPathExpression expr = xpath.compile(xpathExpr);
                NodeList result = (NodeList)expr.evaluate(document, XPathConstants.NODESET);
                if (result.getLength() == 0) {
                    throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"No XML nodes selected"), (ErrorTypeDefinition)CryptoErrors.PARAMETERS);
                }
                return result;
            }
            return new SingleNodeSet(document.getDocumentElement());
        }
        catch (XPathExpressionException e) {
            String message = String.format("Error evaluating Xpath expression '%s'", xpathExpr);
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)message), (ErrorTypeDefinition)CryptoErrors.PARAMETERS, (Throwable)e);
        }
    }

    public static String getIDAttributeName(Element element) {
        List<Node> attributes = NodeListUtils.toList(element.getAttributes());
        Optional<String> foundName = attributes.stream().map(Node::getNodeName).filter(attrName -> attrName.equalsIgnoreCase(ID)).findFirst();
        return foundName.orElse(ID);
    }

    public static void setAttributeAsIdCreatingIfNotFound(Element element, String attributeName) {
        String currentValue = element.getAttribute(attributeName);
        if (currentValue.isEmpty()) {
            element.setAttribute(attributeName, UUID.randomUUID().toString());
        }
        element.setIdAttribute(attributeName, true);
    }

    public static Element validateXpathInDocument(Document document, String expression) {
        if (expression.startsWith("//") || !expression.startsWith("/")) {
            String message = String.format("The provided xpath expression '%s' is not absolute", expression);
            throw new IllegalStateException(message);
        }
        NodeList nodeList = XMLUtils.getElements(expression, document);
        if (nodeList.getLength() == 0) {
            throw new IllegalStateException(NOT_FOUND_ELEMENT_WITH_GIVEN_VALIDATION_EXPRESSION);
        }
        if (nodeList.getLength() > 1) {
            throw new IllegalStateException(MORE_THAN_ONE_ELEMENT_FOUND_WITH_GIVEN_VALIDATION_EXPRESSION);
        }
        return (Element)nodeList.item(0);
    }
}

