/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.pgp;

import com.mulesoft.modules.cryptography.internal.WrappedErrorPipedInputStream;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import com.mulesoft.modules.cryptography.internal.pgp.BouncyCastleClasses;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.InvocationTargetException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class PgpTransformer {
    private static final int BUFFER_SIZE = 65536;
    private static final String ERROR_MESSAGE_ARMORED = "Could not transform binary to armored";

    private PgpTransformer() {
    }

    public static InputStream binaryToArmored(InputStream content, Scheduler scheduler) {
        try {
            Class<?> armoredOutputStream = BouncyCastleClasses.getClass("org.bouncycastle.bcpg.ArmoredOutputStream");
            WrappedErrorPipedInputStream input = new WrappedErrorPipedInputStream();
            PipedOutputStream outputStream = new PipedOutputStream(input);
            OutputStream out = (OutputStream)armoredOutputStream.getDeclaredConstructor(OutputStream.class).newInstance(outputStream);
            try {
                scheduler.submit(() -> {
                    try {
                        int len;
                        byte[] buf = new byte[65536];
                        while ((len = content.read(buf)) >= 0) {
                            out.write(buf, 0, len);
                        }
                    }
                    catch (Exception e) {
                        input.fail(new ModuleException(I18nMessageFactory.createStaticMessage((String)ERROR_MESSAGE_ARMORED), (ErrorTypeDefinition)CryptoErrors.TRANSFORMATION, (Throwable)e));
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)out);
                        IOUtils.closeQuietly((Closeable)outputStream);
                    }
                });
                return input;
            }
            catch (Exception e) {
                throw new ModuleException(I18nMessageFactory.createStaticMessage((String)ERROR_MESSAGE_ARMORED), (ErrorTypeDefinition)CryptoErrors.TRANSFORMATION, (Throwable)e);
            }
        }
        catch (IOException e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)ERROR_MESSAGE_ARMORED), (ErrorTypeDefinition)CryptoErrors.TRANSFORMATION, (Throwable)e);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }
}

