/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.pgp;

import com.mulesoft.modules.cryptography.internal.CryptoUtils;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import com.mulesoft.modules.cryptography.internal.pgp.BouncyCastleClasses;
import com.mulesoft.modules.cryptography.internal.pgp.PgpEncrypter;
import com.mulesoft.modules.cryptography.internal.pgp.config.PgpAsymmetricKeyIdentifier;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class PgpKeystore {
    private final Map<Long, Object> publicKeyMap = new ConcurrentHashMap<Long, Object>();
    private final Map<Long, Object> privateKeyMap = new ConcurrentHashMap<Long, Object>();
    private final Map<String, Long> principalMap = new ConcurrentHashMap<String, Long>();
    private final Map<Long, String> fingerprintToPrincipalMap;
    private final Map<Long, String> passPhrasesMap = new ConcurrentHashMap<Long, String>();
    private Object pbeSecretKeyDecryptorBuilder = null;
    public static final Object KEY_FINGERPRINT_CALCULATOR;

    public PgpKeystore(String publicKeyring, String privateKeyring) {
        this.fingerprintToPrincipalMap = new ConcurrentHashMap<Long, String>();
        if (publicKeyring != null) {
            this.readPublicKeys(publicKeyring);
        }
        if (privateKeyring != null) {
            this.readPrivateKeys(privateKeyring);
        }
        this.reversePrincipalMap();
        this.getPbeSecretKeyDecryptorBuilder();
    }

    private synchronized void reversePrincipalMap() {
        this.principalMap.forEach((principal, fingerprint) -> this.fingerprintToPrincipalMap.put((Long)fingerprint, (String)principal));
    }

    public synchronized void registerPassphrase(Long fingerprint, String passphrase) {
        this.getPrivateKey(fingerprint);
        this.passPhrasesMap.put(fingerprint, passphrase);
    }

    public String getPrincipalFromFingerprint(Long fingerprint) {
        return this.fingerprintToPrincipalMap.get(fingerprint);
    }

    public Long getFingerprintFromPrincipal(String principal) {
        return this.principalMap.get(principal);
    }

    public Long getFingerprintFromIdentifier(PgpAsymmetricKeyIdentifier keyIdentifier) {
        return keyIdentifier.getFingerprint(this);
    }

    public Object getPublicKey(Long fingerprint) {
        Object key = this.publicKeyMap.get(fingerprint);
        if (key == null) {
            I18nMessage message = I18nMessageFactory.createStaticMessage((String)String.format("Public key with fingerprint '%s' was not found", PgpEncrypter.formatKeyFingerprint(fingerprint)));
            throw new ModuleException(message, (ErrorTypeDefinition)CryptoErrors.MISSING_KEY);
        }
        return key;
    }

    public boolean hasPrivateKey(Long fingerprint) {
        return this.privateKeyMap.get(fingerprint) != null;
    }

    public Object getPrivateKey(Long fingerprint) {
        Object key = this.privateKeyMap.get(fingerprint);
        if (key == null) {
            I18nMessage message = I18nMessageFactory.createStaticMessage((String)String.format("Private key with fingerprint '%s' was not found", PgpEncrypter.formatKeyFingerprint(fingerprint)));
            throw new ModuleException(message, (ErrorTypeDefinition)CryptoErrors.MISSING_KEY);
        }
        return key;
    }

    public Object decryptPrivateKey(Long fingerprint, Optional<String> passphrase) {
        Class<?> jcePBESecretKeyDecryptorBuilder = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder");
        Class<?> pGPSecretKey = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPSecretKey");
        Class<?> pBESecretKeyDecryptor = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor");
        Object encryptedKey = this.getPrivateKey(fingerprint);
        String passphraseText = passphrase.orElseGet(() -> this.passPhrasesMap.get(fingerprint));
        if (passphraseText == null) {
            I18nMessage message = I18nMessageFactory.createStaticMessage((String)("Passphrase not available for key " + PgpEncrypter.formatKeyFingerprint(fingerprint)));
            throw new ModuleException(message, (ErrorTypeDefinition)CryptoErrors.PASSPHRASE);
        }
        try {
            CryptoUtils.getBcSecurityProviderIfApplicable().ifPresent(provider -> {
                try {
                    jcePBESecretKeyDecryptorBuilder.getDeclaredMethod("setProvider", Provider.class).invoke(this.pbeSecretKeyDecryptorBuilder, provider);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            });
            Object secretKeyDecryptor = jcePBESecretKeyDecryptorBuilder.getDeclaredMethod("build", char[].class).invoke(this.pbeSecretKeyDecryptorBuilder, new Object[]{passphraseText.toCharArray()});
            return pGPSecretKey.getDeclaredMethod("extractPrivateKey", pBESecretKeyDecryptor).invoke(encryptedKey, secretKeyDecryptor);
        }
        catch (InvocationTargetException e) {
            String errorMessage = CryptoUtils.getSafeErrorMessage(e, "PGP decryption failed");
            Throwable cause = e.getCause() != null ? e.getCause() : e;
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)errorMessage), (ErrorTypeDefinition)(errorMessage.contains("passphrase") || errorMessage.contains("mismatch") ? CryptoErrors.PASSPHRASE : CryptoErrors.DECRYPTION), cause);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            String message = CryptoUtils.getSafeErrorMessage(e, "Error accessing PGP key");
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)message), (Throwable)e);
        }
    }

    public Object decryptPrivateKey(Long fingerprint) {
        return this.decryptPrivateKey(fingerprint, Optional.empty());
    }

    private void processUserIds(Iterator<Object> userIds, long keyId) {
        userIds.forEachRemaining(principal -> {
            if (this.principalMap.containsKey(principal) && keyId != this.principalMap.get(principal)) {
                throw new IllegalArgumentException(String.format("Principal '%s' appears more than once in different keys (%s and %s)", principal, keyId, this.principalMap.get(principal)));
            }
            this.principalMap.put((String)principal, keyId);
        });
    }

    private void handleKeyProcessingException(Exception e, String operation) {
        String message = CryptoUtils.getSafeErrorMessage(e, "Error " + operation);
        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)message), (Throwable)e);
    }

    private void processKeyRings(Object keys, Class<?> keyRingCollectionClass, Class<?> keyRingClass, Class<?> keyClass, boolean isPublic) {
        try {
            Iterator keyrings = (Iterator)keyRingCollectionClass.getDeclaredMethod("getKeyRings", new Class[0]).invoke(keys, new Object[0]);
            keyrings.forEachRemaining(keyRing -> {
                try {
                    String methodName = isPublic ? "getPublicKeys" : "getSecretKeys";
                    Iterator keyIterator = (Iterator)keyRingClass.getDeclaredMethod(methodName, new Class[0]).invoke(keyRing, new Object[0]);
                    keyIterator.forEachRemaining(key -> {
                        try {
                            long keyId = (Long)keyClass.getDeclaredMethod("getKeyID", new Class[0]).invoke(key, new Object[0]);
                            if (isPublic) {
                                this.publicKeyMap.put(keyId, key);
                            } else {
                                this.privateKeyMap.put(keyId, key);
                            }
                            Iterator userIds = (Iterator)keyClass.getDeclaredMethod("getUserIDs", new Class[0]).invoke(key, new Object[0]);
                            this.processUserIds(userIds, keyId);
                        }
                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                            this.handleKeyProcessingException(e, "processing " + (isPublic ? "public" : "private") + " key");
                        }
                    });
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    this.handleKeyProcessingException(e, "reading " + (isPublic ? "public" : "private") + " key ring");
                }
            });
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.handleKeyProcessingException(e, "processing key rings");
        }
    }

    private void readPublicKeys(String path) {
        try (InputStream inputStream = IOUtils.getResourceAsStream((String)path, this.getClass());){
            Preconditions.checkArgument((inputStream != null ? 1 : 0) != 0, () -> String.format("Public PGP keyring '%s' does not exist", path));
            Class<?> pGPPublicKeyRingCollection = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPPublicKeyRingCollection");
            Class<?> pGPPublictKey = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPPublicKey");
            Class<?> pGPPublicKeyRing = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPPublicKeyRing");
            Class<?> pGPUtil = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPUtil");
            InputStream decoderStream = (InputStream)pGPUtil.getDeclaredMethod("getDecoderStream", InputStream.class).invoke(null, inputStream);
            Object publicKeys = pGPPublicKeyRingCollection.getDeclaredConstructor(InputStream.class, BouncyCastleClasses.getClass("org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator")).newInstance(decoderStream, KEY_FINGERPRINT_CALCULATOR);
            this.processKeyRings(publicKeys, pGPPublicKeyRingCollection, pGPPublicKeyRing, pGPPublictKey, true);
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            this.handleKeyProcessingException(e, "reading public keyring");
        }
    }

    private void readPrivateKeys(String path) {
        try {
            Class<?> pGPSecretKeyRingCollection = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPSecretKeyRingCollection");
            Class<?> pGPSecretKeyRing = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPSecretKeyRing");
            Class<?> pGPSecretKey = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPSecretKey");
            Object privateKeys = this.readPGPSecretKeyRingCollection(path);
            this.processKeyRings(privateKeys, pGPSecretKeyRingCollection, pGPSecretKeyRing, pGPSecretKey, false);
        }
        catch (Exception e) {
            this.handleKeyProcessingException(e, "reading private keyring");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object readPGPSecretKeyRingCollection(String path) {
        try (InputStream inputStream = IOUtils.getResourceAsStream((String)path, this.getClass());){
            Class<?> pGPObjectFactory = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPObjectFactory");
            Class<?> pGPSecretKeyRingCollection = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPSecretKeyRingCollection");
            Class<?> pGPSecretKeyRing = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPSecretKeyRing");
            Class<?> keyFingerPrintCalculator = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator");
            Class<?> pGPUtil = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPUtil");
            Preconditions.checkArgument((inputStream != null ? 1 : 0) != 0, () -> String.format("Private PGP keyring '%s' does not exist", path));
            InputStream decoderStram = (InputStream)pGPUtil.getDeclaredMethod("getDecoderStream", InputStream.class).invoke(null, inputStream);
            Iterable pgpFact = (Iterable)pGPObjectFactory.getDeclaredConstructor(InputStream.class, keyFingerPrintCalculator).newInstance(decoderStram, KEY_FINGERPRINT_CALCULATOR);
            ArrayList secretRings = new ArrayList();
            for (Object obj : pgpFact) {
                if (!obj.getClass().equals(pGPSecretKeyRing)) continue;
                secretRings.add(obj);
            }
            Iterator<Object> iterator = pGPSecretKeyRingCollection.getDeclaredConstructor(Collection.class).newInstance(secretRings);
            return iterator;
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            String message = CryptoUtils.getSafeErrorMessage(e, "Error reading PGP secret key ring collection");
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)message), (Throwable)e);
        }
    }

    private synchronized void getPbeSecretKeyDecryptorBuilder() {
        if (Objects.isNull(this.pbeSecretKeyDecryptorBuilder)) {
            try {
                Class<?> pGPDigestCalculatorProvider = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider");
                Class<?> jcaPGPDigestCalculatorProviderBuilder = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder");
                Class<?> jcePBESecretKeyDecryptorBuilder = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder");
                Object pgpDigestCalculatorProviderBuilder = jcaPGPDigestCalculatorProviderBuilder.newInstance();
                Object pgpDigestCalculatorProvider = jcaPGPDigestCalculatorProviderBuilder.getDeclaredMethod("build", new Class[0]).invoke(pgpDigestCalculatorProviderBuilder, new Object[0]);
                this.pbeSecretKeyDecryptorBuilder = jcePBESecretKeyDecryptorBuilder.getDeclaredConstructor(pGPDigestCalculatorProvider).newInstance(pgpDigestCalculatorProvider);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                String message = CryptoUtils.getSafeErrorMessage(e, "Error initializing PBE secret key decryptor builder");
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)message), (Throwable)e);
            }
        }
    }

    static {
        try {
            Class<?> jcaKeyFingerprintCalculator = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator");
            KEY_FINGERPRINT_CALCULATOR = jcaKeyFingerprintCalculator.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }
}

