/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.pgp;

import com.mulesoft.modules.cryptography.api.pgp.config.PgpEncryptionAlgorithm;
import com.mulesoft.modules.cryptography.api.pgp.config.PgpKeyInfo;
import com.mulesoft.modules.cryptography.internal.CryptoUtils;
import com.mulesoft.modules.cryptography.internal.WrappedErrorPipedInputStream;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import com.mulesoft.modules.cryptography.internal.pgp.BouncyCastleClasses;
import com.mulesoft.modules.cryptography.internal.pgp.config.PgpConfiguration;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.Provider;
import java.util.AbstractMap;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.sdk.api.streaming.bytes.ImmutableFileRepeatableInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpEncrypter {
    private static final int BUFFER_SIZE = 65536;
    private static final String PGP_ERROR_MESSAGE = "Could not encrypt with PGP";
    private static final String SET_PROVIDER_METHOD = "setProvider";
    private static final Logger LOGGER = LoggerFactory.getLogger(PgpEncrypter.class);
    private final PgpConfiguration config;

    public static String formatKeyFingerprint(Long fingerprint) {
        return Long.toHexString(fingerprint).toUpperCase();
    }

    public PgpEncrypter(PgpConfiguration config) {
        this.config = config;
    }

    public InputStream encrypt(InputStream inputData, String fileName, PgpKeyInfo encryptKeyInfo, PgpEncryptionAlgorithm algorithm, boolean disableMDC, Scheduler scheduler, Boolean armoredTransform) {
        return this.encrypt(inputData, fileName, encryptKeyInfo, algorithm, Optional.empty(), disableMDC, scheduler, armoredTransform);
    }

    public InputStream encrypt(InputStream inputData, String fileName, PgpKeyInfo encryptKeyInfo, PgpEncryptionAlgorithm algorithm, Optional<PgpKeyInfo> signKeyInfo, boolean disableMDC, Scheduler scheduler, Boolean armoredTransform) {
        try {
            if (encryptKeyInfo.isSymmetric()) {
                throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Symmetric encryption with PGP is not implemented yet"), (ErrorTypeDefinition)CryptoErrors.ENCRYPTION);
            }
            Class<?> jcePGPDataEncryptorBuilder = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder");
            Class<?> pGPDataEncryptorBuilder = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder");
            Class<?> jcePublicKeyKeyEncryptionMethodGenerator = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator");
            Class<?> pGPEncryptedDataGenerator = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPEncryptedDataGenerator");
            Class<?> pGPCompressedDataGenerator = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPCompressedDataGenerator");
            Class<?> pGPLiteralDataGenerator = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPLiteralDataGenerator");
            Class<?> pGPKeyEncryptionMethodGenerator = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator");
            Class<?> pGPPublicKey = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPPublicKey");
            Class<?> pGPCompressedData = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPCompressedData");
            Class<?> armoredOutputStream = BouncyCastleClasses.getClass("org.bouncycastle.bcpg.ArmoredOutputStream");
            Object encryptionKey = encryptKeyInfo.getPublicKey(this.config.getKeystore());
            Object encryptorBuilder = jcePGPDataEncryptorBuilder.getDeclaredConstructor(Integer.TYPE).newInstance(algorithm.getNumericId());
            CryptoUtils.getBcSecurityProviderIfApplicable().ifPresent(provider -> {
                try {
                    jcePGPDataEncryptorBuilder.getMethod(SET_PROVIDER_METHOD, Provider.class).invoke(encryptorBuilder, provider);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            });
            jcePGPDataEncryptorBuilder.getDeclaredMethod("setWithIntegrityPacket", Boolean.TYPE).invoke(encryptorBuilder, !disableMDC);
            Object encryptedDataGenerator = pGPEncryptedDataGenerator.getDeclaredConstructor(pGPDataEncryptorBuilder, Boolean.TYPE).newInstance(encryptorBuilder, false);
            Object methodGenerator = jcePublicKeyKeyEncryptionMethodGenerator.getDeclaredConstructor(pGPPublicKey).newInstance(encryptionKey);
            CryptoUtils.getBcSecurityProviderIfApplicable().ifPresent(provider -> {
                try {
                    jcePublicKeyKeyEncryptionMethodGenerator.getMethod(SET_PROVIDER_METHOD, Provider.class).invoke(methodGenerator, provider);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            });
            pGPEncryptedDataGenerator.getDeclaredMethod("addMethod", pGPKeyEncryptionMethodGenerator).invoke(encryptedDataGenerator, methodGenerator);
            Object compressedDataGenerator = pGPCompressedDataGenerator.getDeclaredConstructor(Integer.TYPE).newInstance(pGPCompressedData.getField("ZIP").get(null));
            Object literalDataGenerator = pGPLiteralDataGenerator.newInstance();
            WrappedErrorPipedInputStream input = new WrappedErrorPipedInputStream();
            PipedOutputStream pipedOutputStream = new PipedOutputStream(input);
            OutputStream out = (OutputStream)armoredOutputStream.getDeclaredConstructor(OutputStream.class).newInstance(pipedOutputStream);
            scheduler.submit(() -> this.encryptAsync(encryptedDataGenerator, compressedDataGenerator, out, input, pipedOutputStream, signKeyInfo, literalDataGenerator, fileName, inputData, armoredTransform));
            return input;
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)PGP_ERROR_MESSAGE), (ErrorTypeDefinition)CryptoErrors.ENCRYPTION, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public InputStream encryptAsync(Object encryptedDataGenerator, Object compressedDataGenerator, OutputStream out, WrappedErrorPipedInputStream input, PipedOutputStream pipedOutputStream, Optional<PgpKeyInfo> signKeyInfo, Object literalDataGenerator, String fileName, InputStream inputData, boolean armoredTransform) {
        block18: {
            encryptorEntryPoint = null;
            compressorEntryPoint = null;
            signatureGeneratorDeferredTillClose = null;
            literalGeneratorEntryPoint = null;
            try {
                pGPEncryptedDataGenerator = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPEncryptedDataGenerator");
                pGPCompressedDataGenerator = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPCompressedDataGenerator");
                pGPLiteralDataGenerator = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPLiteralDataGenerator");
                pGPSignatureGenerator = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPSignatureGenerator");
                pGPLiteralData = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPLiteralData");
                encryptorEntryPoint = (OutputStream)pGPEncryptedDataGenerator.getDeclaredMethod("open", new Class[]{OutputStream.class, byte[].class}).invoke(encryptedDataGenerator, new Object[]{armoredTransform != false ? out : pipedOutputStream, new byte[65536]});
                compressorEntryPoint = (OutputStream)pGPCompressedDataGenerator.getDeclaredMethod("open", new Class[]{OutputStream.class, byte[].class}).invoke(compressedDataGenerator, new Object[]{encryptorEntryPoint, new byte[65536]});
                signatureGeneratorDeferredTillClose = this.generateSignatureGeneratorClosable(signKeyInfo, compressorEntryPoint);
                literalGeneratorEntryPoint = (OutputStream)pGPLiteralDataGenerator.getDeclaredMethod("open", new Class[]{OutputStream.class, Character.TYPE, String.class, Date.class, byte[].class}).invoke(literalDataGenerator, new Object[]{compressorEntryPoint, pGPLiteralData.getField("BINARY").get(null), fileName, new Date(), new byte[65536]});
                buf = new byte[65536];
                while ((readBytesLength = inputData.read(buf)) > 0) {
                    literalGeneratorEntryPoint.write(buf, 0, readBytesLength);
                    if (!signatureGeneratorDeferredTillClose.isEnabled()) continue;
                    pGPSignatureGenerator.getDeclaredMethod("update", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}).invoke(signatureGeneratorDeferredTillClose.getSignatureGenerator(), new Object[]{buf, 0, readBytesLength});
                }
                ** try [egrp 1[TRYBLOCK] [0 : 351->393)] { 
            }
            catch (ModuleException moduleException) {
                input.fail(moduleException);
                break block18;
            }
            catch (AssertionError | Exception e) {
                errorMessage = CryptoUtils.getSafeErrorMessage((Throwable)e, e instanceof AssertionError != false && e.getClass().getName().contains("FipsUnapprovedOperation") != false ? "Operation not approved in FIPS mode" : "Could not encrypt with PGP");
                input.fail(new ModuleException(I18nMessageFactory.createStaticMessage((String)errorMessage), (ErrorTypeDefinition)CryptoErrors.ENCRYPTION, (Throwable)e));
                break block18;
                {
                    catch (Throwable var22_29) {
                        throw var22_29;
                    }
                }
            }
            finally {
                try {
                    inputData.close();
                    IOUtils.closeQuietly(literalGeneratorEntryPoint);
                    if (signatureGeneratorDeferredTillClose != null) {
                        signatureGeneratorDeferredTillClose.close();
                    }
                    IOUtils.closeQuietly(compressorEntryPoint);
                    IOUtils.closeQuietly(encryptorEntryPoint);
                    IOUtils.closeQuietly((Closeable)out);
                    IOUtils.closeQuietly((Closeable)pipedOutputStream);
                }
                catch (Exception e) {
                    errorMessage = CryptoUtils.getSafeErrorMessage(e, "Could not encrypt with PGP");
                    input.fail(new ModuleException(I18nMessageFactory.createStaticMessage((String)errorMessage), (ErrorTypeDefinition)CryptoErrors.ENCRYPTION, (Throwable)e));
                }
            }
lbl-1000:
            // 1 sources

            {
                inputData.close();
                IOUtils.closeQuietly((Closeable)literalGeneratorEntryPoint);
                if (signatureGeneratorDeferredTillClose != null) {
                    signatureGeneratorDeferredTillClose.close();
                }
                IOUtils.closeQuietly((Closeable)compressorEntryPoint);
                IOUtils.closeQuietly((Closeable)encryptorEntryPoint);
                IOUtils.closeQuietly((Closeable)out);
                IOUtils.closeQuietly((Closeable)pipedOutputStream);
            }
lbl32:
            // 1 sources

            catch (Exception e) {
                errorMessage = CryptoUtils.getSafeErrorMessage(e, "Could not encrypt with PGP");
                input.fail(new ModuleException(I18nMessageFactory.createStaticMessage((String)errorMessage), (ErrorTypeDefinition)CryptoErrors.ENCRYPTION, (Throwable)e));
            }
            {
            }
        }
        return input;
    }

    protected SignatureGeneratorClosable generateSignatureGeneratorClosable(Optional<PgpKeyInfo> signerKeyInfo, OutputStream compressorEntryPoint) {
        boolean enabled = signerKeyInfo.isPresent();
        Object signatureGenerator = null;
        if (enabled) {
            Object senderPrivateKey = signerKeyInfo.get().getPrivateKey(this.config.getKeystore());
            signatureGenerator = this.prepareSignatureGenerator(compressorEntryPoint, senderPrivateKey);
        }
        if (signatureGenerator != null) {
            return new SignatureGeneratorClosable(enabled, signatureGenerator, compressorEntryPoint);
        }
        return new NullSignatureGeneratorClosable();
    }

    private Object prepareSignatureGenerator(OutputStream compressedOutputStream, Object senderPrivateKey) {
        try {
            Class<?> pGPSignatureGenerator = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPSignatureGenerator");
            Class<?> jcaPGPContentSignerBuilder = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder");
            Class<?> pGPContentSignerBuilder = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.operator.PGPContentSignerBuilder");
            Class<?> pGPSignatureSubpacketGenerator = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator");
            Class<?> pGPPrivateKey = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPPrivateKey");
            Class<?> pGPOnePassSignature = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPOnePassSignature");
            Class<?> publicKeyPacket = BouncyCastleClasses.getClass("org.bouncycastle.bcpg.PublicKeyPacket");
            Class<?> pGPSignatureSubpacketVector = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPSignatureSubpacketVector");
            Class<?> pGPSignature = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPSignature");
            Class<?> hashAlgorithmTags = BouncyCastleClasses.getClass("org.bouncycastle.bcpg.HashAlgorithmTags");
            Object publicPacket = pGPPrivateKey.getDeclaredMethod("getPublicKeyPacket", new Class[0]).invoke(senderPrivateKey, new Object[0]);
            Object algorithm = publicKeyPacket.getDeclaredMethod("getAlgorithm", new Class[0]).invoke(publicPacket, new Object[0]);
            Object signerBuilder = jcaPGPContentSignerBuilder.getDeclaredConstructor(Integer.TYPE, Integer.TYPE).newInstance(algorithm, hashAlgorithmTags.getField("SHA1").get(null));
            Object signatureGenerator = pGPSignatureGenerator.getDeclaredConstructor(pGPContentSignerBuilder).newInstance(signerBuilder);
            pGPSignatureGenerator.getDeclaredMethod("init", Integer.TYPE, pGPPrivateKey).invoke(signatureGenerator, pGPSignature.getField("BINARY_DOCUMENT").get(null), senderPrivateKey);
            Object signatureSubpacketGenerator = pGPSignatureSubpacketGenerator.newInstance();
            long keyId = (Long)pGPPrivateKey.getDeclaredMethod("getKeyID", new Class[0]).invoke(senderPrivateKey, new Object[0]);
            pGPSignatureSubpacketGenerator.getDeclaredMethod("addSignerUserID", Boolean.TYPE, String.class).invoke(signatureSubpacketGenerator, false, this.getUserIdFrom(keyId));
            Object generatedSignatureSubpacket = pGPSignatureSubpacketGenerator.getDeclaredMethod("generate", new Class[0]).invoke(signatureSubpacketGenerator, new Object[0]);
            pGPSignatureGenerator.getDeclaredMethod("setHashedSubpackets", pGPSignatureSubpacketVector).invoke(signatureGenerator, generatedSignatureSubpacket);
            Object onePassVersion = pGPSignatureGenerator.getDeclaredMethod("generateOnePassVersion", Boolean.TYPE).invoke(signatureGenerator, false);
            pGPOnePassSignature.getDeclaredMethod("encode", OutputStream.class).invoke(onePassVersion, compressedOutputStream);
            return signatureGenerator;
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private String getUserIdFrom(long keyId) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> pGPPublicKey = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPPublicKey");
        String retrievedFromFingerprintMapping = this.config.getKeystore().getPrincipalFromFingerprint(keyId);
        if (retrievedFromFingerprintMapping != null) {
            return retrievedFromFingerprintMapping;
        }
        Object publicKey = this.config.getKeystore().getPublicKey(keyId);
        Iterator userIds = (Iterator)pGPPublicKey.getDeclaredMethod("getUserIDs", new Class[0]).invoke(publicKey, new Object[0]);
        return (String)userIds.next();
    }

    private Object getEncryptedDataListFromInput(InputStream inputData) {
        try {
            Class<?> jcaPGPObjectFactory = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory");
            Class<?> pGPEncryptedDataList = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPEncryptedDataList");
            Class<?> pGPUtil = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPUtil");
            InputStream decodedInputStream = (InputStream)pGPUtil.getDeclaredMethod("getDecoderStream", InputStream.class).invoke(null, inputData);
            Object pgpF = jcaPGPObjectFactory.getDeclaredConstructor(InputStream.class).newInstance(decodedInputStream);
            Object pgpObject = jcaPGPObjectFactory.getMethod("nextObject", new Class[0]).invoke(pgpF, new Object[0]);
            if (pgpObject == null) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Invalid PGP message"));
            }
            Object enc = pgpObject.getClass().equals(pGPEncryptedDataList) ? pgpObject : jcaPGPObjectFactory.getMethod("nextObject", new Class[0]).invoke(pgpF, new Object[0]);
            return enc;
        }
        catch (InvocationTargetException e) {
            String errorMessage = CryptoUtils.getSafeErrorMessage(e, PGP_ERROR_MESSAGE);
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)errorMessage), (ErrorTypeDefinition)CryptoErrors.ENCRYPTION);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private Map.Entry<Object, Object> getPublicAndPrivateKeyTuple(Object encryptedDataList) {
        try {
            Class<?> pGPEncryptedDataList = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPEncryptedDataList");
            Class<?> pGPPublicKeyEncryptedData = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPPublicKeyEncryptedData");
            Object pbe = null;
            Object privateKey = null;
            Iterator it = (Iterator)pGPEncryptedDataList.getDeclaredMethod("getEncryptedDataObjects", new Class[0]).invoke(encryptedDataList, new Object[0]);
            while (it.hasNext()) {
                pbe = it.next();
                long keyId = (Long)pGPPublicKeyEncryptedData.getDeclaredMethod("getKeyID", new Class[0]).invoke(pbe, new Object[0]);
                if (!this.config.getKeystore().hasPrivateKey(keyId)) continue;
                privateKey = this.config.getKeystore().decryptPrivateKey(keyId);
                break;
            }
            if (privateKey == null) {
                throw new ModuleException("No valid private key found", (ErrorTypeDefinition)CryptoErrors.MISSING_KEY);
            }
            return new AbstractMap.SimpleEntry<Object, Object>(pbe, privateKey);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private InputStream decodeInputDataWithKeys(Object pbe, Object privateKey) throws InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        Class<?> jcePublicKeyDataDecryptorFactoryBuilder = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder");
        Class<?> pGPPrivateKey = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPPrivateKey");
        Class<?> pGPPublicKeyEncryptedData = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPPublicKeyEncryptedData");
        Class<?> publicKeyDataDecryptorFactory = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory");
        Object jcePublicKeyDataDecryptorFactoryBuilderInstance = jcePublicKeyDataDecryptorFactoryBuilder.newInstance();
        CryptoUtils.getBcSecurityProviderIfApplicable().ifPresent(provider -> {
            try {
                jcePublicKeyDataDecryptorFactoryBuilder.getDeclaredMethod(SET_PROVIDER_METHOD, Provider.class).invoke(jcePublicKeyDataDecryptorFactoryBuilderInstance, provider);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        });
        Object publicKeyDataDecryptorFactoryInstance = jcePublicKeyDataDecryptorFactoryBuilder.getDeclaredMethod("build", pGPPrivateKey).invoke(jcePublicKeyDataDecryptorFactoryBuilderInstance, privateKey);
        return (InputStream)pGPPublicKeyEncryptedData.getDeclaredMethod("getDataStream", publicKeyDataDecryptorFactory).invoke(pbe, publicKeyDataDecryptorFactoryInstance);
    }

    public InputStream decrypt(InputStream inputData, String fileName, boolean validateIfSignatureFound) {
        try {
            boolean shouldValidateSignature;
            DecryptedData decryptedData = this.getDecryptedInputStream(inputData, fileName);
            Object onePassSignature = decryptedData.getOnePassSignature();
            Object pgpObjectFactory = decryptedData.getJcaPGPObjectFactory();
            InputStream literalDataStream = decryptedData.getDecryptedInputStream();
            boolean bl = shouldValidateSignature = onePassSignature != null && validateIfSignatureFound;
            if (shouldValidateSignature) {
                return this.verifySignature(onePassSignature, pgpObjectFactory, literalDataStream);
            }
            return literalDataStream;
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Could not decrypt PGP data"), (ErrorTypeDefinition)CryptoErrors.DECRYPTION, (Throwable)e);
        }
    }

    private InputStream verifySignature(Object onePassSignature, Object pgpObjectFactory, InputStream literalDataStream) throws IOException {
        try {
            int len;
            Class<?> jcaPGPContentVerifierBuilderProvider = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider");
            Class<?> pGPOnePassSignature = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPOnePassSignature");
            Class<?> pGPPublicKey = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPPublicKey");
            Class<?> pGPContentVerifierBuilderProvider = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider");
            Class<?> pGPSignatureList = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPSignatureList");
            Class<?> jcaPGPObjectFactory = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory");
            Class<?> pGPSignature = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPSignature");
            LOGGER.debug("One pass signature found, and validation was requested. Starting validation procedure");
            Object contentVerifierBuilderProvider = jcaPGPContentVerifierBuilderProvider.newInstance();
            Long keyId = (Long)pGPOnePassSignature.getDeclaredMethod("getKeyID", new Class[0]).invoke(onePassSignature, new Object[0]);
            pGPOnePassSignature.getDeclaredMethod("init", pGPContentVerifierBuilderProvider, pGPPublicKey).invoke(onePassSignature, contentVerifierBuilderProvider, this.config.getKeystore().getPublicKey(keyId));
            byte[] buffer = new byte[1024];
            LOGGER.debug("About to do a pass over the literal decrypted data");
            TemporarySaverDataUtil temporarySaverDataUtil = new TemporarySaverDataUtil();
            while ((len = literalDataStream.read(buffer)) > -1) {
                temporarySaverDataUtil.write(buffer, 0, len);
                pGPOnePassSignature.getDeclaredMethod("update", byte[].class, Integer.TYPE, Integer.TYPE).invoke(onePassSignature, buffer, 0, len);
            }
            Object signatureList = jcaPGPObjectFactory.getMethod("nextObject", new Class[0]).invoke(pgpObjectFactory, new Object[0]);
            Object signature = pGPSignatureList.getDeclaredMethod("get", Integer.TYPE).invoke(signatureList, 0);
            Object publicKey = this.config.getKeystore().getPublicKey(keyId);
            Object verifierBuilderProvider = jcaPGPContentVerifierBuilderProvider.newInstance();
            CryptoUtils.getBcSecurityProviderIfApplicable().ifPresent(provider -> {
                try {
                    jcaPGPContentVerifierBuilderProvider.getDeclaredMethod(SET_PROVIDER_METHOD, Provider.class).invoke(verifierBuilderProvider, provider);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            });
            pGPSignature.getDeclaredMethod("init", pGPContentVerifierBuilderProvider, pGPPublicKey).invoke(signature, verifierBuilderProvider, publicKey);
            boolean isValidSignature = (Boolean)pGPOnePassSignature.getDeclaredMethod("verify", pGPSignature).invoke(onePassSignature, signature);
            if (!isValidSignature) {
                LOGGER.error("Discovered signature verification failed!");
                throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Could not verify signature of decrypted message"), (ErrorTypeDefinition)CryptoErrors.DECRYPTION);
            }
            return temporarySaverDataUtil.getDecryptedData();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private DecryptedData getDecryptedInputStream(InputStream inputData, String fileName) {
        try {
            Class<?> jcaPGPObjectFactory = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory");
            Class<?> pGPLiteralData = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPLiteralData");
            Class<?> pGPOnePassSignatureList = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPOnePassSignatureList");
            Class<?> pGPCompressedData = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPCompressedData");
            DecryptedData decryptedData = new DecryptedData();
            Object encryptedDataList = this.getEncryptedDataListFromInput(inputData);
            Map.Entry<Object, Object> publicAndPrivateKeyTuple = this.getPublicAndPrivateKeyTuple(encryptedDataList);
            Object pbe = publicAndPrivateKeyTuple.getKey();
            Object privateKey = publicAndPrivateKeyTuple.getValue();
            InputStream decodedInputStream = this.decodeInputDataWithKeys(pbe, privateKey);
            Object pgpObjectFactory = jcaPGPObjectFactory.getDeclaredConstructor(InputStream.class).newInstance(decodedInputStream);
            Object pgpObject = jcaPGPObjectFactory.getMethod("nextObject", new Class[0]).invoke(pgpObjectFactory, new Object[0]);
            decryptedData.setJcaPGPObjectFactory(pgpObjectFactory);
            Object onePassSignature = null;
            while (!pgpObject.getClass().equals(pGPLiteralData)) {
                if (pgpObject.getClass().equals(pGPOnePassSignatureList)) {
                    onePassSignature = pGPOnePassSignatureList.getDeclaredMethod("get", Integer.TYPE).invoke(pgpObject, 0);
                    decryptedData.setOnePassSignature(onePassSignature);
                    pgpObject = jcaPGPObjectFactory.getMethod("nextObject", new Class[0]).invoke(pgpObjectFactory, new Object[0]);
                    continue;
                }
                if (pgpObject.getClass().equals(pGPCompressedData)) {
                    InputStream dataStream = (InputStream)pGPCompressedData.getDeclaredMethod("getDataStream", new Class[0]).invoke(pgpObject, new Object[0]);
                    pgpObjectFactory = jcaPGPObjectFactory.getDeclaredConstructor(InputStream.class).newInstance(dataStream);
                    decryptedData.setJcaPGPObjectFactory(pgpObjectFactory);
                    pgpObject = jcaPGPObjectFactory.getMethod("nextObject", new Class[0]).invoke(pgpObjectFactory, new Object[0]);
                    continue;
                }
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"input is not PGPLiteralData - type unknown."));
            }
            InputStream literalDataStream = (InputStream)pGPLiteralData.getDeclaredMethod("getInputStream", new Class[0]).invoke(pgpObject, new Object[0]);
            decryptedData.setDecryptedInputStream(literalDataStream);
            return decryptedData;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private class DecryptedData {
        private InputStream decryptedInputStream;
        private Object onePassSignature;
        private Object jcaPGPObjectFactory;

        private DecryptedData() {
        }

        public void setDecryptedInputStream(InputStream decryptedInputStream) {
            this.decryptedInputStream = decryptedInputStream;
        }

        public void setOnePassSignature(Object onePassSignature) {
            this.onePassSignature = onePassSignature;
        }

        public void setJcaPGPObjectFactory(Object jcaPGPObjectFactory) {
            this.jcaPGPObjectFactory = jcaPGPObjectFactory;
        }

        public InputStream getDecryptedInputStream() {
            return this.decryptedInputStream;
        }

        public Object getOnePassSignature() {
            return this.onePassSignature;
        }

        public Object getJcaPGPObjectFactory() {
            return this.jcaPGPObjectFactory;
        }
    }

    private class TemporarySaverDataUtil {
        private static final int AMOUNT_OUT_BYTES_AROUND_220MB = 220686720;
        private int amountOfBytesLoaded = 0;
        private File temp = null;
        private OutputStream tempFileOutputStream = null;
        private ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();

        private TemporarySaverDataUtil() {
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this.amountOfBytesLoaded < 220686720) {
                this.amountOfBytesLoaded += b.length;
                this.byteArrayOutputStream.write(b, off, len);
            } else {
                this.initializeTemporaryFileIfNull();
                this.tempFileOutputStream.write(b, off, len);
            }
        }

        public InputStream getDecryptedData() throws IOException {
            if (this.amountOfBytesLoaded < 220686720) {
                this.byteArrayOutputStream.flush();
                return new ByteArrayInputStream(this.byteArrayOutputStream.toByteArray());
            }
            this.byteArrayOutputStream = null;
            return new ImmutableFileRepeatableInputStream(this.temp, true);
        }

        private void initializeTemporaryFileIfNull() throws IOException {
            if (this.temp == null) {
                Path secureTempDir = Paths.get(System.getProperty("user.home"), ".mulesoft-crypto-temp");
                Files.createDirectories(secureTempDir, new FileAttribute[0]);
                this.temp = Files.createTempFile(secureTempDir, "crypto-", ".tmp", new FileAttribute[0]).toFile();
                this.temp.deleteOnExit();
                LOGGER.debug("200 MB size reached while decrypting and verifying signature, writing TEMP file to: {}", (Object)this.temp.getAbsolutePath());
                this.tempFileOutputStream = Files.newOutputStream(this.temp.toPath(), new OpenOption[0]);
                try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.byteArrayOutputStream.toByteArray());){
                    int len;
                    byte[] buffer = new byte[1024];
                    while ((len = byteArrayInputStream.read(buffer)) > -1) {
                        this.tempFileOutputStream.write(buffer, 0, len);
                    }
                }
                this.byteArrayOutputStream.reset();
                this.byteArrayOutputStream = null;
            }
        }
    }

    protected class SignatureGeneratorClosable
    implements AutoCloseable {
        private final boolean enabled;
        private final Object signatureGenerator;
        private final OutputStream compressorEntryPoint;

        private SignatureGeneratorClosable(boolean enabled, Object signatureGenerator, OutputStream compressorEntryPoint) {
            this.enabled = enabled;
            this.signatureGenerator = signatureGenerator;
            this.compressorEntryPoint = compressorEntryPoint;
        }

        @Override
        public void close() throws Exception {
            if (this.enabled) {
                Class<?> pGPSignatureGenerator = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPSignatureGenerator");
                Class<?> pGPSignature = BouncyCastleClasses.getClass("org.bouncycastle.openpgp.PGPSignature");
                Object signature = pGPSignatureGenerator.getMethod("generate", new Class[0]).invoke(this.signatureGenerator, new Object[0]);
                pGPSignature.getDeclaredMethod("encode", OutputStream.class).invoke(signature, this.compressorEntryPoint);
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Object getSignatureGenerator() {
            return this.signatureGenerator;
        }
    }

    private class NullSignatureGeneratorClosable
    extends SignatureGeneratorClosable {
        private NullSignatureGeneratorClosable() {
            super(false, null, null);
        }
    }
}

