/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.jce.parser;

import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class PbeAlgorithmParser {
    private PbeAlgorithmParser() {
    }

    public static ParsedAlgorithm parse(String algorithm) {
        ParsedAlgorithm result = new ParsedAlgorithm();
        result.original = algorithm;
        result.transformation = algorithm;
        if (algorithm.matches("^(HmacPBESHA|PBKDF2withHmac|PBEWithHmac)[A-Z0-9]+$")) {
            result.kdfAlgorithm = algorithm;
            result.isFullTransformation = false;
            result.transformationString = null;
            result.sunStyleTransformation = algorithm.startsWith("PBEWith") || algorithm.startsWith("HmacPBESHA");
            return result;
        }
        if (algorithm.contains("__")) {
            String[] parts = algorithm.split("__");
            if (parts.length == 4 && parts[0].startsWith("PBKDF2withHmac")) {
                result.kdfAlgorithm = parts[0];
                result.cipherAlgorithm = PbeAlgorithmParser.extractCipherName(parts[1]);
                if (!"AES".equalsIgnoreCase(result.cipherAlgorithm) && !PbeAlgorithmParser.allowCustomCipher()) {
                    throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Only AES cipher is supported for custom PBKDF2 format unless 'com.mulesoft.crypto.allow-custom-cipher-in-pbkdf2-format=true' is set."), (ErrorTypeDefinition)CryptoErrors.PARAMETERS);
                }
                if (result.cipherAlgorithm.equalsIgnoreCase(parts[1].toUpperCase())) {
                    throw new ModuleException(I18nMessageFactory.createStaticMessage((String)("Invalid transformation: Invalid cipher name in custom algorithm definition: " + algorithm)), (ErrorTypeDefinition)CryptoErrors.PARAMETERS);
                }
                result.keyLength = PbeAlgorithmParser.extractKeyLength(parts[1]);
                result.transformationString = String.format("%s/%s/%s", result.cipherAlgorithm, parts[2], parts[3]);
                result.isFullTransformation = true;
                result.sunStyleTransformation = false;
                return result;
            }
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)("Invalid transformation: missing cipher, mode or padding in custom algorithm definition: " + algorithm)), (ErrorTypeDefinition)CryptoErrors.PARAMETERS);
        }
        Matcher sunMatcher = Pattern.compile("^PBEWith(?<digest>[A-Za-z0-9]{1,32})And(?<cipher>[A-Za-z0-9_]{1,32})$").matcher(algorithm);
        if (sunMatcher.find()) {
            result.kdfAlgorithm = "PBEWith" + sunMatcher.group("digest");
            result.cipherAlgorithm = PbeAlgorithmParser.extractCipherName(sunMatcher.group("cipher"));
            result.keyLength = PbeAlgorithmParser.extractKeyLength(sunMatcher.group("cipher"));
            result.transformationString = algorithm;
            result.isFullTransformation = true;
            result.sunStyleTransformation = true;
            return result;
        }
        Matcher bcMatcher = Pattern.compile("^PBEwith(?<digest>[A-Za-z0-9]{1,32})and(?<cipher>[A-Za-z0-9\\-]{1,32})$").matcher(algorithm);
        if (bcMatcher.find()) {
            result.kdfAlgorithm = "PBEwith" + bcMatcher.group("digest");
            result.cipherAlgorithm = PbeAlgorithmParser.extractCipherName(bcMatcher.group("cipher"));
            result.keyLength = PbeAlgorithmParser.extractKeyLength(bcMatcher.group("cipher"));
            result.transformationString = algorithm;
            result.isFullTransformation = true;
            result.sunStyleTransformation = false;
            return result;
        }
        throw new ModuleException(I18nMessageFactory.createStaticMessage((String)("Invalid transformation: " + algorithm)), (ErrorTypeDefinition)CryptoErrors.PARAMETERS);
    }

    private static String extractCipherName(String fullName) {
        if (fullName == null) {
            return null;
        }
        String upper = fullName.toUpperCase();
        if (upper.contains("3-KEYDESEDE")) {
            return "3-KeyDESede";
        }
        if (upper.contains("2-KEYDESEDE")) {
            return "2-KeyDESede";
        }
        if (upper.contains("TRIPLEDES")) {
            return "TripleDES";
        }
        if (upper.contains("DESEDE")) {
            return "DESede";
        }
        if (upper.contains("3DES")) {
            return "3DES";
        }
        if (upper.startsWith("AES")) {
            return "AES";
        }
        if (upper.contains("DES")) {
            return "DES";
        }
        if (upper.contains("RC2")) {
            return "RC2";
        }
        if (upper.contains("RC4")) {
            return "RC4";
        }
        return fullName;
    }

    private static int extractKeyLength(String input) {
        Matcher matcher = Pattern.compile("(\\d{3})").matcher(input);
        return matcher.find() ? Integer.parseInt(matcher.group(1)) : 0;
    }

    private static boolean allowCustomCipher() {
        return Boolean.getBoolean("com.mulesoft.crypto.allow-custom-cipher-in-pbkdf2-format");
    }

    public static class ParsedAlgorithm {
        public String original;
        public String transformation;
        public String kdfAlgorithm;
        public String cipherAlgorithm;
        public int keyLength;
        public boolean sunStyleTransformation;
        public boolean isFullTransformation;
        public String transformationString;

        public boolean isSunStyleTransformation() {
            return this.sunStyleTransformation;
        }

        public int getKeyLength() {
            return this.keyLength;
        }
    }
}

