/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.jce.encrypter;

import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.mule.encryption.jce.JCEEncrypter;
import org.mule.encryption.key.EncryptionKeyFactory;

public class JCEPbeEncryptor
extends JCEEncrypter {
    private final PBEKeySpec pbeKeySpec;
    public static final String DEFAULT_SALT_VALUE = "12345678";
    public static final Integer DEFAULT_ITERATOR_COUNT_VALUE = 20;

    public JCEPbeEncryptor(String transformation, EncryptionKeyFactory keyFactory, PBEKeySpec pbeKeySpec) {
        this(transformation, null, keyFactory, pbeKeySpec);
    }

    public JCEPbeEncryptor(String transformation, String provider, EncryptionKeyFactory keyFactory, PBEKeySpec pbeKeySpec) {
        super(transformation, provider, keyFactory);
        this.pbeKeySpec = pbeKeySpec;
    }

    protected AlgorithmParameterSpec getAlgorithmParameterSpec(IvParameterSpec ivParam) {
        return new PBEParameterSpec(this.pbeKeySpec.getSalt() != null ? this.pbeKeySpec.getSalt() : DEFAULT_SALT_VALUE.getBytes(), this.pbeKeySpec.getIterationCount() != 0 ? this.pbeKeySpec.getIterationCount() : DEFAULT_ITERATOR_COUNT_VALUE.intValue(), ivParam);
    }
}

