/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.jce;

import com.mulesoft.modules.cryptography.api.jce.config.JceKeystoreType;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class JceKeystore {
    private final KeyStore keystore;
    private final ConcurrentMap<Pair<String, String>, Key> keyCache = new ConcurrentHashMap<Pair<String, String>, Key>();
    private final ConcurrentMap<Pair<String, String>, KeyStore.Entry> keyEntryCache = new ConcurrentHashMap<Pair<String, String>, KeyStore.Entry>();

    public JceKeystore(String path, JceKeystoreType type, String password) {
        try {
            this.keystore = KeyStore.getInstance(type.name());
            InputStream resource = IOUtils.getResourceAsStream((String)path, this.getClass());
            if (resource == null) {
                throw new FileNotFoundException(String.format("Could not find JCE keystore '%s'", path));
            }
            this.keystore.load(resource, password.toCharArray());
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public Key getPublicKey(String alias) {
        try {
            Certificate certificate = this.keystore.getCertificate(alias);
            if (certificate == null) {
                I18nMessage message = I18nMessageFactory.createStaticMessage((String)String.format("Public key for alias '%s' not found", alias));
                throw new ModuleException(message, (ErrorTypeDefinition)CryptoErrors.MISSING_KEY);
            }
            if (certificate instanceof X509Certificate) {
                X509Certificate x509Cert = (X509Certificate)certificate;
                try {
                    x509Cert.checkValidity();
                }
                catch (CertificateExpiredException | CertificateNotYetValidException e) {
                    I18nMessage message = I18nMessageFactory.createStaticMessage((String)String.format("Certificate for alias '%s' is not valid", alias));
                    throw new ModuleException(message, (ErrorTypeDefinition)CryptoErrors.KEY);
                }
            }
            return certificate.getPublicKey();
        }
        catch (NullPointerException | KeyStoreException e) {
            I18nMessage message = I18nMessageFactory.createStaticMessage((String)String.format("Error obtaining public key for alias '%s'", alias));
            throw new ModuleException(message, (ErrorTypeDefinition)CryptoErrors.KEY);
        }
    }

    private Key getKey(String alias, String password) {
        return this.keyCache.computeIfAbsent((Pair<String, String>)new Pair((Object)alias, (Object)password), k -> {
            try {
                return this.keystore.getKey((String)k.getFirst(), ((String)k.getSecond()).toCharArray());
            }
            catch (NullPointerException | KeyStoreException | NoSuchAlgorithmException e) {
                I18nMessage message = I18nMessageFactory.createStaticMessage((String)String.format("Error obtaining key for alias '%s'", k.getFirst()));
                throw new ModuleException(message, (ErrorTypeDefinition)CryptoErrors.MISSING_KEY);
            }
            catch (UnrecoverableKeyException e) {
                I18nMessage message = I18nMessageFactory.createStaticMessage((String)String.format("Wrong password for key '%s'", k.getFirst()));
                throw new ModuleException(message, (ErrorTypeDefinition)CryptoErrors.PASSPHRASE);
            }
        });
    }

    private KeyStore.Entry getKeyEntry(String alias, String password) {
        return this.keyEntryCache.computeIfAbsent((Pair<String, String>)new Pair((Object)alias, (Object)password), k -> {
            try {
                return this.keystore.getEntry((String)k.getFirst(), new KeyStore.PasswordProtection(((String)k.getSecond()).toCharArray()));
            }
            catch (KeyStoreException | NoSuchAlgorithmException e) {
                I18nMessage message = I18nMessageFactory.createStaticMessage((String)String.format("Error obtaining key entry for alias '%s'", k.getFirst()));
                throw new ModuleException(message, (ErrorTypeDefinition)CryptoErrors.MISSING_KEY);
            }
            catch (UnrecoverableEntryException e) {
                I18nMessage message = I18nMessageFactory.createStaticMessage((String)String.format("Wrong password for key '%s'", k.getFirst()));
                throw new ModuleException(message, (ErrorTypeDefinition)CryptoErrors.PASSPHRASE);
            }
        });
    }

    public Key getPrivateKey(String alias, String password) {
        Key key = this.getKey(alias, password);
        if (key != null) {
            return key;
        }
        I18nMessage message = I18nMessageFactory.createStaticMessage((String)String.format("Private key for alias '%s' not found", alias));
        throw new ModuleException(message, (ErrorTypeDefinition)CryptoErrors.MISSING_KEY);
    }

    public KeyStore.Entry getEntry(String alias, String password) {
        KeyStore.Entry key = this.getKeyEntry(alias, password);
        if (key != null) {
            return key;
        }
        I18nMessage message = I18nMessageFactory.createStaticMessage((String)String.format("Key for alias '%s' not found", alias));
        throw new ModuleException(message, (ErrorTypeDefinition)CryptoErrors.MISSING_KEY);
    }

    public boolean keyExists(String alias) {
        try {
            return this.keystore.containsAlias(alias);
        }
        catch (KeyStoreException e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)("Keystore error when searching for key: " + alias)), (ErrorTypeDefinition)CryptoErrors.KEY, (Throwable)e);
        }
    }

    public KeyStore getUnderlyingKeyStore() {
        return this.keystore;
    }
}

