/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.api.pgp.config;

import com.mulesoft.modules.cryptography.api.pgp.config.PgpKeyInfo;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import com.mulesoft.modules.cryptography.internal.pgp.PgpKeystore;
import com.mulesoft.modules.cryptography.internal.pgp.config.PgpAsymmetricKeyIdentifier;
import java.util.Optional;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class PgpAsymmetricKeyInfo
implements PgpKeyInfo {
    @Parameter
    private String keyId;
    @ParameterGroup(name="Key pair identifier")
    private PgpAsymmetricKeyIdentifier keyPairIdentifier;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    private String passphrase;

    @Override
    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public PgpAsymmetricKeyIdentifier getKeyPairIdentifier() {
        return this.keyPairIdentifier;
    }

    public void setKeyPairIdentifier(PgpAsymmetricKeyIdentifier keyPairIdentifier) {
        this.keyPairIdentifier = keyPairIdentifier;
    }

    @Override
    public Object getPublicKey(PgpKeystore keystore) {
        Long fingerprint = keystore.getFingerprintFromIdentifier(this.keyPairIdentifier);
        return keystore.getPublicKey(fingerprint);
    }

    @Override
    public Object getPrivateKey(PgpKeystore keystore) {
        Long fingerprint = keystore.getFingerprintFromIdentifier(this.keyPairIdentifier);
        return keystore.decryptPrivateKey(fingerprint, Optional.ofNullable(this.passphrase));
    }

    @Override
    public String getSymmetricKey() {
        throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Asymmetric key used where symmetric expected"), (ErrorTypeDefinition)CryptoErrors.KEY);
    }

    @Override
    public boolean isSymmetric() {
        return false;
    }
}

