/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.bcpg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.shaded.bcpg.AEADUtils;
import org.bouncycastle.shaded.bcpg.BCPGInputStream;
import org.bouncycastle.shaded.bcpg.BCPGOutputStream;
import org.bouncycastle.shaded.bcpg.ContainedPacket;
import org.bouncycastle.shaded.bcpg.S2K;
import org.bouncycastle.shaded.bcpg.UnsupportedPacketVersionException;

public class SymmetricKeyEncSessionPacket
extends ContainedPacket {
    public static final int VERSION_4 = 4;
    public static final int VERSION_5 = 5;
    public static final int VERSION_6 = 6;
    private int version;
    private int encAlgorithm;
    private S2K s2k;
    private byte[] s2kBytes;
    private byte[] secKeyData;
    private int aeadAlgorithm;
    private byte[] iv;
    private byte[] authTag;

    public SymmetricKeyEncSessionPacket(BCPGInputStream bCPGInputStream) throws IOException {
        this.version = bCPGInputStream.read();
        if (this.version == 4) {
            this.encAlgorithm = bCPGInputStream.read();
            this.s2k = new S2K(bCPGInputStream);
            this.secKeyData = bCPGInputStream.readAll();
        } else if (this.version == 5 || this.version == 6) {
            int n = bCPGInputStream.read();
            this.encAlgorithm = bCPGInputStream.read();
            this.aeadAlgorithm = bCPGInputStream.read();
            int n2 = bCPGInputStream.read();
            this.s2kBytes = new byte[n2];
            bCPGInputStream.readFully(this.s2kBytes);
            try {
                this.s2k = new S2K(new ByteArrayInputStream(this.s2kBytes));
            }
            catch (UnsupportedPacketVersionException unsupportedPacketVersionException) {
                // empty catch block
            }
            int n3 = n - 3 - n2;
            this.iv = new byte[n3];
            if (bCPGInputStream.read(this.iv) != this.iv.length) {
                throw new EOFException("Premature end of stream.");
            }
            int n4 = AEADUtils.getAuthTagLength(this.aeadAlgorithm);
            this.authTag = new byte[n4];
            byte[] byArray = bCPGInputStream.readAll();
            this.secKeyData = new byte[byArray.length - n4];
            System.arraycopy(byArray, 0, this.secKeyData, 0, this.secKeyData.length);
            System.arraycopy(byArray, this.secKeyData.length, this.authTag, 0, n4);
        } else {
            throw new UnsupportedPacketVersionException("Unsupported PGP symmetric-key encrypted session key packet version encountered: " + this.version);
        }
    }

    public static SymmetricKeyEncSessionPacket createV4Packet(int n, S2K s2K, byte[] byArray) {
        return new SymmetricKeyEncSessionPacket(n, s2K, byArray);
    }

    public static SymmetricKeyEncSessionPacket createV5Packet(int n, int n2, byte[] byArray, S2K s2K, byte[] byArray2, byte[] byArray3) {
        return new SymmetricKeyEncSessionPacket(5, n, n2, byArray, s2K, byArray2, byArray3);
    }

    public static SymmetricKeyEncSessionPacket createV6Packet(int n, int n2, byte[] byArray, S2K s2K, byte[] byArray2, byte[] byArray3) {
        return new SymmetricKeyEncSessionPacket(6, n, n2, byArray, s2K, byArray2, byArray3);
    }

    public SymmetricKeyEncSessionPacket(int n, S2K s2K, byte[] byArray) {
        this.version = 4;
        this.encAlgorithm = n;
        this.s2k = s2K;
        this.secKeyData = byArray;
    }

    private SymmetricKeyEncSessionPacket(int n, int n2, int n3, byte[] byArray, S2K s2K, byte[] byArray2, byte[] byArray3) {
        this.version = n;
        this.encAlgorithm = n2;
        this.aeadAlgorithm = n3;
        this.s2k = s2K;
        this.secKeyData = byArray2;
        int n4 = AEADUtils.getIVLength(n3);
        if (n4 != byArray.length) {
            throw new IllegalArgumentException("Mismatched AEAD IV length. Expected " + n4 + ", got " + byArray.length);
        }
        this.iv = byArray;
        int n5 = AEADUtils.getAuthTagLength(n3);
        if (n5 != byArray3.length) {
            throw new IllegalArgumentException("Mismatched AEAD AuthTag length. Expected " + n5 + ", got " + byArray3.length);
        }
        this.authTag = byArray3;
    }

    public int getEncAlgorithm() {
        return this.encAlgorithm;
    }

    public S2K getS2K() {
        return this.s2k;
    }

    public byte[] getSecKeyData() {
        return this.secKeyData;
    }

    public int getVersion() {
        return this.version;
    }

    public int getAeadAlgorithm() {
        return this.aeadAlgorithm;
    }

    public byte[] getIv() {
        return this.iv;
    }

    public byte[] getAuthTag() {
        return this.authTag;
    }

    public byte[] getAAData() {
        return SymmetricKeyEncSessionPacket.createAAData(this.getVersion(), this.getEncAlgorithm(), this.getAeadAlgorithm());
    }

    public static byte[] createAAData(int n, int n2, int n3) {
        byte[] byArray = new byte[]{-61, (byte)(n & 0xFF), (byte)(n2 & 0xFF), (byte)(n3 & 0xFF)};
        return byArray;
    }

    @Override
    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BCPGOutputStream bCPGOutputStream2 = this.version == 4 ? new BCPGOutputStream(byteArrayOutputStream) : new BCPGOutputStream((OutputStream)byteArrayOutputStream, true);
        bCPGOutputStream2.write(this.version);
        if (this.version == 4) {
            bCPGOutputStream2.write(this.encAlgorithm);
            bCPGOutputStream2.writeObject(this.s2k);
            if (this.secKeyData != null && this.secKeyData.length > 0) {
                bCPGOutputStream2.write(this.secKeyData);
            }
        } else if (this.version == 5 || this.version == 6) {
            int n = this.s2k.getEncoded().length;
            int n2 = 3 + n + this.iv.length;
            bCPGOutputStream2.write(n2);
            bCPGOutputStream2.write(this.encAlgorithm);
            bCPGOutputStream2.write(this.aeadAlgorithm);
            bCPGOutputStream2.write(n);
            bCPGOutputStream2.writeObject(this.s2k);
            bCPGOutputStream2.write(this.iv);
            if (this.secKeyData != null && this.secKeyData.length > 0) {
                bCPGOutputStream2.write(this.secKeyData);
            }
            bCPGOutputStream2.write(this.authTag);
        }
        bCPGOutputStream2.close();
        bCPGOutputStream.writePacket(3, byteArrayOutputStream.toByteArray());
    }
}

