/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.pgp;

import com.mulesoft.modules.cryptography.api.pgp.config.PgpKeyInfo;
import com.mulesoft.modules.cryptography.api.pgp.config.PgpSignatureAlgorithm;
import com.mulesoft.modules.cryptography.internal.FipsUtils;
import com.mulesoft.modules.cryptography.internal.WrappedErrorPipedInputStream;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import com.mulesoft.modules.cryptography.internal.pgp.config.PgpConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.shaded.bcpg.ArmoredOutputStream;
import org.bouncycastle.shaded.bcpg.BCPGOutputStream;
import org.bouncycastle.shaded.openpgp.PGPCompressedData;
import org.bouncycastle.shaded.openpgp.PGPException;
import org.bouncycastle.shaded.openpgp.PGPObjectFactory;
import org.bouncycastle.shaded.openpgp.PGPPrivateKey;
import org.bouncycastle.shaded.openpgp.PGPPublicKey;
import org.bouncycastle.shaded.openpgp.PGPSignature;
import org.bouncycastle.shaded.openpgp.PGPSignatureGenerator;
import org.bouncycastle.shaded.openpgp.PGPSignatureList;
import org.bouncycastle.shaded.openpgp.PGPUtil;
import org.bouncycastle.shaded.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.shaded.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.shaded.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class PgpSigner {
    private PgpConfiguration config;
    private static final String PGP_SIGNATURE_ERROR_MESSAGE = "Could not sign with PGP";
    private static final int BUFFER_SIZE = 65536;

    public PgpSigner(PgpConfiguration config) {
        this.config = config;
    }

    public InputStream sign(InputStream inputStream, PgpKeyInfo keyInfo, PgpSignatureAlgorithm algorithm, Scheduler scheduler, Boolean armoredTransform) {
        try {
            if (keyInfo.isSymmetric()) {
                throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"PGP signing is only possible with asymmetric keys"), (ErrorTypeDefinition)CryptoErrors.KEY);
            }
            WrappedErrorPipedInputStream input = new WrappedErrorPipedInputStream();
            PipedOutputStream outputStream = new PipedOutputStream(input);
            BCPGOutputStream bcpgOutputStream = new BCPGOutputStream(outputStream);
            ArmoredOutputStream armoredOutputStream = new ArmoredOutputStream(bcpgOutputStream);
            scheduler.submit(() -> this.asyncSign(inputStream, keyInfo, algorithm, armoredTransform, armoredOutputStream, bcpgOutputStream, input));
            return input;
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)PGP_SIGNATURE_ERROR_MESSAGE), (ErrorTypeDefinition)CryptoErrors.SIGNATURE, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream asyncSign(InputStream inputStream, PgpKeyInfo keyInfo, PgpSignatureAlgorithm algorithm, Boolean armoredTransform, OutputStream armoredOutputStream, BCPGOutputStream bcpgOutputStream, WrappedErrorPipedInputStream input) {
        try {
            int len;
            PGPPrivateKey pgpPrivateKey = keyInfo.getPrivateKey(this.config.getKeystore());
            int keyAlgorithm = pgpPrivateKey.getPublicKeyPacket().getAlgorithm();
            JcaPGPContentSignerBuilder contentSignerBuilder = new JcaPGPContentSignerBuilder(keyAlgorithm, algorithm.getNumericId());
            FipsUtils.getBcSecurityProviderIfApplicable().ifPresent(contentSignerBuilder::setProvider);
            PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator(contentSignerBuilder);
            signatureGenerator.init(0, pgpPrivateKey);
            byte[] buf = new byte[65536];
            while ((len = inputStream.read(buf)) >= 0) {
                signatureGenerator.update(buf, 0, len);
            }
            signatureGenerator.generate().encode(armoredTransform != false ? armoredOutputStream : bcpgOutputStream);
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            input.fail(new ModuleException(I18nMessageFactory.createStaticMessage((String)PGP_SIGNATURE_ERROR_MESSAGE), (ErrorTypeDefinition)CryptoErrors.SIGNATURE, (Throwable)e));
        }
        finally {
            IOUtils.closeQuietly((OutputStream)armoredOutputStream);
            IOUtils.closeQuietly((OutputStream)bcpgOutputStream);
        }
        return input;
    }

    public boolean validate(InputStream inputStream, InputStream expectedSignature) {
        try {
            PGPSignatureList pgpSigList;
            InputStream sigInputStream = PGPUtil.getDecoderStream(expectedSignature);
            PGPObjectFactory pgpObjFactory = new JcaPGPObjectFactory(sigInputStream);
            Object obj = pgpObjFactory.nextObject();
            if (obj instanceof PGPCompressedData) {
                PGPCompressedData c1 = (PGPCompressedData)obj;
                pgpObjFactory = new PGPObjectFactory(c1.getDataStream(), null);
                pgpSigList = (PGPSignatureList)pgpObjFactory.nextObject();
            } else {
                pgpSigList = (PGPSignatureList)obj;
            }
            PGPSignature sig = pgpSigList.get(0);
            PGPPublicKey pubKey = this.config.getKeystore().getPublicKey(sig.getKeyID());
            try {
                this.loadSignatureToValidate(sig, pubKey, inputStream);
            }
            catch (ModuleException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"PGP signature verification failed"), (ErrorTypeDefinition)CryptoErrors.VALIDATION, (Throwable)e);
            }
            sigInputStream.close();
            return sig.verify();
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"PGP signature verification failed"), (ErrorTypeDefinition)CryptoErrors.VALIDATION, (Throwable)e);
        }
    }

    private PGPSignature loadSignatureToValidate(PGPSignature sig, PGPPublicKey pubKey, InputStream inputStream) throws PGPException, IOException {
        int len;
        JcaPGPContentVerifierBuilderProvider verifierBuilderProvider = new JcaPGPContentVerifierBuilderProvider();
        FipsUtils.getBcSecurityProviderIfApplicable().ifPresent(verifierBuilderProvider::setProvider);
        sig.init(verifierBuilderProvider, pubKey);
        byte[] buf = new byte[65536];
        while ((len = inputStream.read(buf)) >= 0) {
            sig.update(buf, 0, len);
        }
        return sig;
    }
}

